/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.tx;

import org.seasar.extension.tx.TransactionManagerAdapter;
import org.seasar.framework.exception.SIllegalArgumentException;

public class TxRule {
    protected final Class exceptionClass;
    protected final boolean commit;

    public TxRule(Class exceptionClass, boolean commit) {
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            throw new SIllegalArgumentException("ESSR0365", new Object[]{exceptionClass.getName()});
        }
        this.exceptionClass = exceptionClass;
        this.commit = commit;
    }

    public boolean isAssignableFrom(Throwable t) {
        return this.exceptionClass.isAssignableFrom(t.getClass());
    }

    public void complete(TransactionManagerAdapter adapter) {
        if (!this.commit) {
            adapter.setRollbackOnly();
        }
    }
}

