/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.filter.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.filter.UrlFilter;
import org.seasar.robot.service.UrlFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlFilterImpl
implements UrlFilter {
    private final Logger logger = LoggerFactory.getLogger(UrlFilterImpl.class);
    protected String urlPattern = "^(.*:/+)([^/]*)(.*)$";
    protected String includeFilteringPattern;
    protected String excludeFilteringPattern;
    protected List<String> cachedIncludeList = new ArrayList<String>();
    protected List<String> cachedExcludeList = new ArrayList<String>();
    protected String sessionId;
    protected UrlFilterService urlFilterService;

    public void addExclude(String urlPattern) {
        try {
            Pattern.compile(urlPattern);
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Invalid exclude pattern: " + urlPattern);
            }
            return;
        }
        if (this.sessionId == null) {
            this.cachedExcludeList.add(urlPattern);
        } else {
            this.getUrlFilterService().addExcludeUrlFilter(this.sessionId, urlPattern);
        }
    }

    public void addInclude(String urlPattern) {
        try {
            Pattern.compile(urlPattern);
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Invalid include pattern: " + urlPattern);
            }
            return;
        }
        if (this.sessionId == null) {
            this.cachedIncludeList.add(urlPattern);
        } else {
            this.getUrlFilterService().addIncludeUrlFilter(this.sessionId, urlPattern);
        }
    }

    public void clear() {
        this.cachedIncludeList.clear();
        this.cachedExcludeList.clear();
        if (this.sessionId != null) {
            this.getUrlFilterService().delete(this.sessionId);
        }
    }

    public void init(String sessionId) {
        this.sessionId = sessionId;
        if (!this.cachedIncludeList.isEmpty()) {
            this.getUrlFilterService().addIncludeUrlFilter(sessionId, this.cachedIncludeList);
            this.cachedIncludeList.clear();
        }
        if (!this.cachedExcludeList.isEmpty()) {
            this.getUrlFilterService().addExcludeUrlFilter(sessionId, this.cachedExcludeList);
            this.cachedExcludeList.clear();
        }
    }

    public boolean match(String url) {
        Matcher matcher;
        boolean match;
        List<Pattern> includeList = this.getUrlFilterService().getIncludeUrlPatternList(this.sessionId);
        List<Pattern> excludeList = this.getUrlFilterService().getExcludeUrlPatternList(this.sessionId);
        if (!includeList.isEmpty()) {
            match = false;
            for (Pattern pattern : includeList) {
                matcher = pattern.matcher(url);
                if (!matcher.matches()) continue;
                match = true;
            }
            if (!match) {
                return false;
            }
        }
        if (!excludeList.isEmpty()) {
            match = false;
            for (Pattern pattern : excludeList) {
                matcher = pattern.matcher(url);
                if (!matcher.matches()) continue;
                match = true;
            }
            if (match) {
                return false;
            }
        }
        return true;
    }

    public void processUrl(String url) {
        if (this.includeFilteringPattern != null) {
            this.addInclude(url.replaceAll(this.urlPattern, this.includeFilteringPattern));
        }
        if (this.excludeFilteringPattern != null) {
            this.addExclude(url.replaceAll(this.urlPattern, this.excludeFilteringPattern));
        }
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getIncludeFilteringPattern() {
        return this.includeFilteringPattern;
    }

    public void setIncludeFilteringPattern(String includeFilteringPattern) {
        this.includeFilteringPattern = includeFilteringPattern;
    }

    public String getExcludeFilteringPattern() {
        return this.excludeFilteringPattern;
    }

    public void setExcludeFilteringPattern(String excludeFilteringPattern) {
        this.excludeFilteringPattern = excludeFilteringPattern;
    }

    public UrlFilterService getUrlFilterService() {
        if (this.urlFilterService == null) {
            this.urlFilterService = (UrlFilterService)SingletonS2Container.getComponent((String)"urlFilterService");
            if (this.urlFilterService == null) {
                throw new RobotSystemException("urlFilterService is not found.");
            }
        }
        return this.urlFilterService;
    }
}

