/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.mime.Clause;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MagicClause;
import org.apache.tika.mime.MagicMatch;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReaderMetKeys;
import org.apache.tika.mime.Operator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class MimeTypesReader
implements MimeTypesReaderMetKeys {
    private final MimeTypes types;

    MimeTypesReader(MimeTypes types) {
        this.types = types;
    }

    void read(String filepath) throws IOException, MimeTypeException {
        this.read(MimeTypesReader.class.getClassLoader().getResourceAsStream(filepath));
    }

    void read(InputStream stream) throws IOException, MimeTypeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(stream));
            this.read(document);
        }
        catch (ParserConfigurationException e) {
            throw new MimeTypeException("Unable to create an XML parser", e);
        }
        catch (SAXException e) {
            throw new MimeTypeException("Invalid type configuration", e);
        }
    }

    void read(Document document) throws MimeTypeException {
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("mime-info")) {
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element child;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(child = (Element)node).getTagName().equals("mime-type")) continue;
                this.readMimeType(child);
            }
        } else {
            throw new MimeTypeException("Not a <mime-info/> configuration document: " + element.getTagName());
        }
    }

    private void readMimeType(Element element) throws MimeTypeException {
        String name = element.getAttribute("type");
        MimeType type = this.types.forName(name);
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element nodeElement = (Element)node;
            if (nodeElement.getTagName().equals("_comment")) {
                type.setDescription(nodeElement.getFirstChild().getNodeValue());
                continue;
            }
            if (nodeElement.getTagName().equals("glob")) {
                boolean useRegex = Boolean.valueOf(nodeElement.getAttribute("isregex"));
                this.types.addPattern(type, nodeElement.getAttribute("pattern"), useRegex);
                continue;
            }
            if (nodeElement.getTagName().equals("magic")) {
                this.readMagic(nodeElement, type);
                continue;
            }
            if (nodeElement.getTagName().equals("alias")) {
                String alias = nodeElement.getAttribute("type");
                type.addAlias(alias);
                continue;
            }
            if (nodeElement.getTagName().equals("root-XML")) {
                this.readRootXML(nodeElement, type);
                continue;
            }
            if (!nodeElement.getTagName().equals("sub-class-of")) continue;
            String parent = nodeElement.getAttribute("type");
            type.setSuperType(this.types.forName(parent));
        }
        this.types.add(type);
    }

    private void readMagic(Element element, MimeType mimeType) throws MimeTypeException {
        Magic magic = new Magic(mimeType);
        String priority = element.getAttribute("priority");
        if (priority != null && priority.length() > 0) {
            magic.setPriority(Integer.parseInt(priority));
        }
        magic.setClause(this.readMatches(element));
        mimeType.addMagic(magic);
    }

    private Clause readMatches(Element element) throws MimeTypeException {
        Clause prev = Clause.FALSE;
        Clause clause = null;
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals("match")) continue;
            clause = this.readMatch(nodeElement);
            Clause sub = this.readMatches(nodeElement);
            if (sub != null) {
                clause = new MagicClause(Operator.AND, clause, sub);
            }
            clause = new MagicClause(Operator.OR, prev, clause);
            prev = clause;
        }
        return clause;
    }

    private MagicMatch readMatch(Element element) throws MimeTypeException {
        String offset = null;
        String value = null;
        String mask = null;
        String type = null;
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("offset")) {
                offset = attr.getValue();
                continue;
            }
            if (attr.getName().equals("type")) {
                type = attr.getValue();
                continue;
            }
            if (attr.getName().equals("value")) {
                value = attr.getValue();
                continue;
            }
            if (!attr.getName().equals("mask")) continue;
            mask = attr.getValue();
        }
        int offStart = 0;
        int offEnd = 0;
        if (offset != null) {
            int colon = offset.indexOf(58);
            if (colon == -1) {
                offEnd = offStart = Integer.parseInt(offset);
            } else {
                offStart = Integer.parseInt(offset.substring(0, colon));
                offEnd = Integer.parseInt(offset.substring(colon + 1));
                offEnd = Math.max(offStart, offEnd);
            }
        }
        return new MagicMatch(offStart, offEnd, type, mask, value);
    }

    private void readRootXML(Element element, MimeType mimeType) {
        mimeType.addRootXML(element.getAttribute("namespaceURI"), element.getAttribute("localName"));
    }
}

