/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.extractor.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;
import org.seasar.robot.entity.ExtractData;
import org.seasar.robot.extractor.ExtractException;
import org.seasar.robot.extractor.Extractor;
import org.seasar.robot.util.StreamUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(TikaExtractor.class);
    public String outputEncoding = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExtractData getText(InputStream inputStream, Map<String, String> params) {
        if (inputStream == null) {
            throw new RobotSystemException("The inputstream is null.");
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tikaExtractor-", ".out");
        }
        catch (IOException e) {
            throw new ExtractException("Could not create a temp file.", e);
        }
        try {
            try {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(tempFile);
                    StreamUtil.drain(inputStream, out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
                FileInputStream in = new FileInputStream(tempFile);
                PrintStream originalOutStream = System.out;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                System.setOut(new PrintStream(outStream, true));
                PrintStream originalErrStream = System.err;
                ByteArrayOutputStream errStream = new ByteArrayOutputStream();
                System.setErr(new PrintStream(errStream, true));
                String resourceName = params != null ? params.get("resourceName") : null;
                String contentType = params != null ? params.get("Content-Type") : null;
                Metadata metadata = this.createMetadata(resourceName, contentType);
                AutoDetectParser parser = new AutoDetectParser();
                ParseContext parseContext = new ParseContext();
                parseContext.set(Parser.class, (Object)parser);
                StringWriter writer = new StringWriter();
                parser.parse((InputStream)in, (ContentHandler)new BodyContentHandler((Writer)writer), metadata, parseContext);
                String content = this.normalizeContent(writer);
                if (StringUtil.isBlank((String)content)) {
                    IOUtils.closeQuietly((InputStream)in);
                    in = new FileInputStream(tempFile);
                    Metadata metadata2 = this.createMetadata(null, contentType);
                    StringWriter writer2 = new StringWriter();
                    parser.parse((InputStream)in, (ContentHandler)new BodyContentHandler((Writer)writer2), metadata2, parseContext);
                    content = this.normalizeContent(writer2);
                }
                ExtractData extractData = new ExtractData(content);
                Object[] names = metadata.names();
                Arrays.sort(names);
                for (Object name : names) {
                    extractData.putValues((String)name, metadata.getValues((String)name));
                }
                ExtractData extractData2 = extractData;
                Object var24_30 = null;
                IOUtils.closeQuietly((InputStream)in);
                if (originalOutStream != null) {
                    System.setOut(originalOutStream);
                }
                if (originalErrStream != null) {
                    System.setErr(originalErrStream);
                }
                try {
                    byte[] bs;
                    if (logger.isInfoEnabled() && (bs = outStream.toByteArray()).length != 0) {
                        logger.info(new String(bs, this.outputEncoding));
                    }
                    if (logger.isWarnEnabled() && (bs = errStream.toByteArray()).length != 0) {
                        logger.warn(new String(bs, this.outputEncoding));
                    }
                }
                catch (Exception e2) {
                }
                Object var27_39 = null;
                if (tempFile != null && !tempFile.delete()) {
                    tempFile.deleteOnExit();
                }
                return extractData2;
                catch (TikaException e) {
                    block35: {
                        ExtractData extractData3;
                        try {
                            Extractor xmlExtractor;
                            Throwable cause = e.getCause();
                            if (!(cause instanceof SAXException) || (xmlExtractor = (Extractor)SingletonS2Container.getComponent((String)"xmlExtractor")) == null) break block35;
                            IOUtils.closeQuietly((InputStream)in);
                            in = new FileInputStream(tempFile);
                            extractData3 = xmlExtractor.getText(in, params);
                            Object var24_31 = null;
                        }
                        catch (Throwable throwable) {
                            Object var24_32 = null;
                            IOUtils.closeQuietly((InputStream)in);
                            if (originalOutStream != null) {
                                System.setOut(originalOutStream);
                            }
                            if (originalErrStream != null) {
                                System.setErr(originalErrStream);
                            }
                            try {
                                byte[] bs;
                                if (logger.isInfoEnabled() && (bs = outStream.toByteArray()).length != 0) {
                                    logger.info(new String(bs, this.outputEncoding));
                                }
                                if (logger.isWarnEnabled() && (bs = errStream.toByteArray()).length != 0) {
                                    logger.warn(new String(bs, this.outputEncoding));
                                }
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)in);
                        if (originalOutStream != null) {
                            System.setOut(originalOutStream);
                        }
                        if (originalErrStream != null) {
                            System.setErr(originalErrStream);
                        }
                        try {
                            byte[] bs;
                            if (logger.isInfoEnabled() && (bs = outStream.toByteArray()).length != 0) {
                                logger.info(new String(bs, this.outputEncoding));
                            }
                            if (logger.isWarnEnabled() && (bs = errStream.toByteArray()).length != 0) {
                                logger.warn(new String(bs, this.outputEncoding));
                            }
                        }
                        catch (Exception e2) {
                        }
                        Object var27_40 = null;
                        if (tempFile != null && !tempFile.delete()) {
                            tempFile.deleteOnExit();
                        }
                        return extractData3;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                throw new ExtractException("Could not extract a content.", e);
            }
        }
        catch (Throwable throwable) {
            block37: {
                Object var27_41 = null;
                if (tempFile == null || tempFile.delete()) break block37;
                tempFile.deleteOnExit();
            }
            throw throwable;
        }
    }

    private String normalizeContent(StringWriter writer2) {
        return writer2.toString().replaceAll("\\s+$", " ").trim();
    }

    private Metadata createMetadata(String resourceName, String contentType) {
        Metadata metadata = new Metadata();
        if (StringUtil.isNotEmpty((String)resourceName)) {
            metadata.set("resourceName", resourceName);
        }
        if (StringUtil.isNotBlank((String)contentType)) {
            metadata.set("Content-Type", contentType);
        }
        return metadata;
    }
}

