/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFileInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(TemporaryFileInputStream.class);
    private File tempFile;
    private FileInputStream fileInputStream;

    public TemporaryFileInputStream(File tempFile) throws FileNotFoundException {
        this.tempFile = tempFile;
        this.fileInputStream = new FileInputStream(tempFile);
    }

    public int read() throws IOException {
        return this.fileInputStream.read();
    }

    public int available() throws IOException {
        return this.fileInputStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        try {
            this.fileInputStream.close();
            Object var2_1 = null;
            if (!this.tempFile.exists()) return;
            if (this.tempFile.delete()) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!this.tempFile.exists() || this.tempFile.delete()) throw throwable;
            logger.warn("Could not delete a temporary file: " + this.tempFile.getAbsolutePath());
            throw throwable;
        }
        logger.warn("Could not delete a temporary file: " + this.tempFile.getAbsolutePath());
    }

    public synchronized void mark(int readlimit) {
        this.fileInputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.fileInputStream.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.fileInputStream.reset();
    }

    public long skip(long n) throws IOException {
        return this.fileInputStream.skip(n);
    }
}

