/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.task.handler.impl.execute;

import java.util.ArrayList;
import org.seasar.chronos.core.annotation.type.JoinType;
import org.seasar.chronos.core.delegate.AsyncResult;
import org.seasar.chronos.core.delegate.MethodInvoker;
import org.seasar.chronos.core.task.Transition;
import org.seasar.chronos.core.task.handler.impl.AbstractTaskExecuteHandler;
import org.seasar.chronos.core.task.impl.TaskMethodMetaData;

public class TaskMethodExecuteHandlerImpl
extends AbstractTaskExecuteHandler {
    private static final long serialVersionUID = 2079527599646118983L;

    public Transition handleRequest(String startTaskName) throws InterruptedException {
        MethodInvoker mi = this.getMethodInvoker();
        ArrayList<AsyncResult> asyncResultList = new ArrayList<AsyncResult>();
        String nextTaskName = startTaskName;
        String lastTaskName = startTaskName;
        while (true) {
            String methodName = this.toMethodName(nextTaskName);
            TaskMethodMetaData md = new TaskMethodMetaData(mi.getMethod(methodName));
            int i = 0;
            while ((long)i < md.getCloneSize()) {
                Transition ts = this.getTerminateTransition(lastTaskName);
                if (ts != null) {
                    return ts;
                }
                AsyncResult ar = mi.beginInvoke(methodName);
                asyncResultList.add(ar);
                ++i;
            }
            Object returnValue = null;
            String _nextTaskName = null;
            if (md.getJoinType() == JoinType.Wait || md.getReturnType() == String.class) {
                for (AsyncResult ar : asyncResultList) {
                    returnValue = mi.endInvoke(ar);
                }
                if (md.getReturnType() == String.class) {
                    _nextTaskName = (String)returnValue;
                }
            }
            String string = nextTaskName = _nextTaskName != null ? _nextTaskName : md.getNextTask();
            if (nextTaskName != null && !this.getMethodGroupMap().existGroup(nextTaskName)) {
                TaskMethodMetaData nextMethodMetaData = new TaskMethodMetaData(mi.getMethod(this.toMethodName(nextTaskName)));
                String nextGroupName = nextMethodMetaData.getGroupName();
                String currentGroupName = md.getGroupName();
                if (nextGroupName != null && !nextGroupName.equals(currentGroupName)) {
                    nextTaskName = nextGroupName;
                }
            }
            if (nextTaskName == null) break;
            if (this.getMethodGroupMap().existGroup(nextTaskName)) {
                return new Transition(false, nextTaskName, lastTaskName);
            }
            lastTaskName = nextTaskName;
        }
        for (AsyncResult ar : asyncResultList) {
            mi.endInvoke(ar);
        }
        return new Transition(true, null, lastTaskName);
    }
}

