/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.h2.constant.SysProperties;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.util.IOUtils;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceObject {
    protected static final int CALLABLE_STATEMENT = 0;
    protected static final int CONNECTION = 1;
    protected static final int DATABASE_META_DATA = 2;
    protected static final int PREPARED_STATEMENT = 3;
    protected static final int RESULT_SET = 4;
    protected static final int RESULT_SET_META_DATA = 5;
    protected static final int SAVEPOINT = 6;
    protected static final int SQL_EXCEPTION = 7;
    protected static final int STATEMENT = 8;
    protected static final int BLOB = 9;
    protected static final int CLOB = 10;
    protected static final int PARAMETER_META_DATA = 11;
    protected static final int DATA_SOURCE = 12;
    protected static final int XA_DATA_SOURCE = 13;
    protected static final int XID = 14;
    protected static final int ARRAY = 15;
    private static final int LAST = 16;
    private static final int[] ID = new int[16];
    private static final String[] PREFIX = new String[]{"call", "conn", "dbMeta", "prep", "rs", "rsMeta", "sp", "ex", "stat", "blob", "clob", "pMeta", "ds", "xads", "xid", "ar"};
    private Trace trace;
    private int traceType;
    private int id;

    protected void setTrace(Trace trace, int n, int n2) {
        this.trace = trace;
        this.traceType = n;
        this.id = n2;
    }

    protected void setTrace(Trace trace) {
        this.trace = trace;
    }

    protected Trace getTrace() {
        return this.trace;
    }

    public int getTraceId() {
        return this.id;
    }

    public String getTraceObjectName() {
        return PREFIX[this.traceType] + this.id;
    }

    protected int getNextId(int n) {
        int n2 = n;
        int n3 = ID[n2];
        ID[n2] = n3 + 1;
        return n3;
    }

    protected boolean isDebugEnabled() {
        return this.trace.isDebugEnabled();
    }

    protected boolean isInfoEnabled() {
        return this.trace.isInfoEnabled();
    }

    protected void debugCodeAssign(String string, int n, int n2, String string2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(string + " " + PREFIX[n] + n2 + " = " + this.getTraceObjectName() + "." + string2 + ";");
        }
    }

    protected void debugCodeCall(String string) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string + "();");
        }
    }

    protected void debugCodeCall(String string, long l) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string + "(" + l + ");");
        }
    }

    protected void debugCodeCall(String string, String string2) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string + "(" + this.quote(string2) + ");");
        }
    }

    protected void debugCode(String string) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debugCode(this.getTraceObjectName() + "." + string);
        }
    }

    protected String quote(String string) {
        return StringUtils.quoteJavaString(string);
    }

    protected String quoteTime(Time time) {
        if (time == null) {
            return "null";
        }
        return "Time.valueOf(\"" + time.toString() + "\")";
    }

    protected String quoteTimestamp(Timestamp timestamp) {
        if (timestamp == null) {
            return "null";
        }
        return "Timestamp.valueOf(\"" + timestamp.toString() + "\")";
    }

    protected String quoteDate(Date date) {
        if (date == null) {
            return "null";
        }
        return "Date.valueOf(\"" + date.toString() + "\")";
    }

    protected String quoteBigDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return "null";
        }
        return "new BigDecimal(\"" + bigDecimal.toString() + "\")";
    }

    protected String quoteBytes(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return "org.h2.util.Utils.convertStringToBytes(\"" + Utils.convertBytesToString(byArray) + "\")";
    }

    protected String quoteArray(String[] stringArray) {
        return StringUtils.quoteJavaStringArray(stringArray);
    }

    protected String quoteIntArray(int[] nArray) {
        return StringUtils.quoteJavaIntArray(nArray);
    }

    protected String quoteMap(Map<String, Class<?>> map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "new Map()";
        }
        StringBuilder stringBuilder = new StringBuilder("new Map() /* ");
        try {
            for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
                String string = entry.getKey();
                Class<?> clazz = entry.getValue();
                stringBuilder.append(string).append(':').append(clazz.getName());
            }
        }
        catch (Exception exception) {
            stringBuilder.append(exception.toString()).append(": ").append(map.toString());
        }
        stringBuilder.append("*/");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected SQLException logAndConvert(Exception exception) {
        SQLException sQLException = DbException.toSQLException(exception);
        if (SysProperties.LOG_ALL_ERRORS) {
            Class<TraceObject> clazz = TraceObject.class;
            // MONITORENTER : org.h2.message.TraceObject.class
            try {
                Writer writer = IOUtils.getWriter(IOUtils.openFileOutputStream(SysProperties.LOG_ALL_ERRORS_FILE, true));
                PrintWriter printWriter = new PrintWriter(writer);
                sQLException.printStackTrace(printWriter);
                printWriter.close();
                writer.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        if (this.trace == null) {
            TraceSystem.traceThrowable(sQLException);
            return sQLException;
        }
        int n = sQLException.getErrorCode();
        if (n >= 23000 && n < 24000) {
            this.trace.info("SQLException", sQLException);
            return sQLException;
        }
        this.trace.error("SQLException", sQLException);
        return sQLException;
    }

    protected SQLException unsupported(String string) throws SQLException {
        try {
            throw DbException.getUnsupportedException(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public static String toString(String string, ArrayList<? extends ParameterInterface> arrayList) {
        StatementBuilder statementBuilder = new StatementBuilder(string);
        if (arrayList != null && arrayList.size() > 0) {
            statementBuilder.append(" {");
            int n = 0;
            for (ParameterInterface parameterInterface : arrayList) {
                ++n;
                try {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(n).append(": ");
                    if (parameterInterface == null || parameterInterface.getParamValue() == null) {
                        statementBuilder.append('-');
                        continue;
                    }
                    statementBuilder.append(parameterInterface.getParamValue().getSQL());
                }
                catch (Exception exception) {
                    statementBuilder.append("/* ").append(n).append(": ").append(exception.toString()).append("*/ ");
                }
            }
            statementBuilder.append("};");
        }
        return statementBuilder.toString();
    }
}

