/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.valuetype.registered;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.seasar.dbflute.util.DfTypeUtil;

public class DoubleType
extends TnAbstractValueType {
    public DoubleType() {
        super(8);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return DfTypeUtil.toDouble(resultSet.getObject(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return DfTypeUtil.toDouble(resultSet.getObject(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return DfTypeUtil.toDouble(cs.getObject(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return DfTypeUtil.toDouble(cs.getObject(parameterName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setDouble(index, DfTypeUtil.toPrimitiveDouble(value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setDouble(parameterName, DfTypeUtil.toPrimitiveDouble(value));
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return DfTypeUtil.nullText();
        }
        Double var = DfTypeUtil.toDouble(value);
        return DfTypeUtil.toText(var);
    }
}

