/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean;

import org.seasar.robot.dbflute.cbean.FetchBean;
import org.seasar.robot.dbflute.cbean.FetchNarrowingBean;

public class FetchAssistContext {
    private static ThreadLocal<FetchBean> _threadLocal = new ThreadLocal();

    public static FetchBean getFetchBeanOnThread() {
        return _threadLocal.get();
    }

    public static void setFetchBeanOnThread(FetchBean fetchBean) {
        if (fetchBean == null) {
            String msg = "The argument[fetchBean] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(fetchBean);
    }

    public static boolean isExistFetchBeanOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearFetchBeanOnThread() {
        _threadLocal.set(null);
    }

    public static FetchNarrowingBean getFetchNarrowingBeanOnThread() {
        FetchBean bean;
        if (FetchAssistContext.isExistFetchBeanOnThread() && (bean = FetchAssistContext.getFetchBeanOnThread()) instanceof FetchNarrowingBean) {
            return (FetchNarrowingBean)bean;
        }
        return null;
    }

    public static boolean isExistFetchNarrowingBeanOnThread() {
        return FetchAssistContext.getFetchNarrowingBeanOnThread() != null;
    }
}

