/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.cbean.chelper;

import java.lang.reflect.Method;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.ConditionBeanContext;
import org.seasar.robot.dbflute.cbean.ConditionQuery;
import org.seasar.robot.dbflute.cbean.SubQuery;
import org.seasar.robot.dbflute.cbean.chelper.HpSDRSetupper;
import org.seasar.robot.dbflute.dbmeta.DBMeta;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;
import org.seasar.robot.dbflute.util.DfStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HpSDRFunction<REFERRER_CB extends ConditionBean, LOCAL_CQ extends ConditionQuery> {
    protected ConditionBean _baseCB;
    protected LOCAL_CQ _localCQ;
    protected HpSDRSetupper<REFERRER_CB, LOCAL_CQ> _querySetupper;
    protected DBMetaProvider _dbmetaProvider;

    public HpSDRFunction(ConditionBean baseCB, LOCAL_CQ localCQ, HpSDRSetupper<REFERRER_CB, LOCAL_CQ> querySetupper, DBMetaProvider dbmetaProvider) {
        this._baseCB = baseCB;
        this._localCQ = localCQ;
        this._querySetupper = querySetupper;
        this._dbmetaProvider = dbmetaProvider;
    }

    public void count(SubQuery<REFERRER_CB> subQuery, String aliasName) {
        this.assertAliasName(aliasName);
        this._querySetupper.setup("count", subQuery, this._localCQ, aliasName.trim());
    }

    public void countDistinct(SubQuery<REFERRER_CB> subQuery, String aliasName) {
        this.assertAliasName(aliasName);
        this._querySetupper.setup("count(distinct", subQuery, this._localCQ, aliasName.trim());
    }

    public void max(SubQuery<REFERRER_CB> subQuery, String aliasName) {
        this.assertAliasName(aliasName);
        this._querySetupper.setup("max", subQuery, this._localCQ, aliasName.trim());
    }

    public void min(SubQuery<REFERRER_CB> subQuery, String aliasName) {
        this.assertAliasName(aliasName);
        this._querySetupper.setup("min", subQuery, this._localCQ, aliasName.trim());
    }

    public void sum(SubQuery<REFERRER_CB> subQuery, String aliasName) {
        this.assertAliasName(aliasName);
        this._querySetupper.setup("sum", subQuery, this._localCQ, aliasName.trim());
    }

    public void avg(SubQuery<REFERRER_CB> subQuery, String aliasName) {
        this.assertAliasName(aliasName);
        this._querySetupper.setup("avg", subQuery, this._localCQ, aliasName.trim());
    }

    protected void assertAliasName(String aliasName) {
        if (aliasName == null || aliasName.trim().length() == 0) {
            this.throwSpecifyDerivedReferrerInvalidAliasNameException();
        }
        String tableDbName = this._baseCB.getTableDbName();
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(tableDbName);
        Method[] methods = dbmeta.getEntityType().getMethods();
        String targetMethodName = "set" + this.replaceString(aliasName, "_", "").toLowerCase();
        boolean existsSetterMethod = false;
        for (Method method : methods) {
            if (!method.getName().startsWith("set") || !targetMethodName.equals(method.getName().toLowerCase())) continue;
            existsSetterMethod = true;
            break;
        }
        if (!existsSetterMethod) {
            this.throwSpecifyDerivedReferrerEntityPropertyNotFoundException(aliasName, dbmeta.getEntityType());
        }
    }

    protected void throwSpecifyDerivedReferrerInvalidAliasNameException() {
        ConditionBeanContext.throwSpecifyDerivedReferrerInvalidAliasNameException(this._localCQ);
    }

    protected void throwSpecifyDerivedReferrerEntityPropertyNotFoundException(String aliasName, Class<?> entityType) {
        ConditionBeanContext.throwSpecifyDerivedReferrerEntityPropertyNotFoundException(aliasName, entityType);
    }

    protected String replaceString(String text, String fromText, String toText) {
        return DfStringUtil.replace(text, fromText, toText);
    }
}

