/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.EntityProcessor;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityProcessorBase
extends EntityProcessor {
    private static final Logger log = LoggerFactory.getLogger(EntityProcessorBase.class);
    protected boolean isFirstInit = true;
    protected String entityName;
    protected Context context;
    protected VariableResolverImpl resolver;
    protected Iterator<Map<String, Object>> rowIterator;
    protected List<Transformer> transformers;
    protected String query;
    protected String onError = "abort";
    protected String cachePk;
    protected String cacheVariableName;
    protected Map<String, List<Map<String, Object>>> simpleCache;
    protected Map<String, Map<Object, List<Map<String, Object>>>> cacheWithWhereClause;
    protected List<Map<String, Object>> dataSourceRowCache;
    public static final String TRANSFORMER = "transformer";
    public static final String TRANSFORM_ROW = "transformRow";
    public static final String ON_ERROR = "onError";
    public static final String ABORT = "abort";
    public static final String CONTINUE = "continue";
    public static final String SKIP = "skip";
    public static final String SKIP_DOC = "$skipDoc";
    public static final String CACHE_KEY = "cacheKey";
    public static final String CACHE_LOOKUP = "cacheLookup";

    @Override
    public void init(Context context) {
        this.rowIterator = null;
        this.context = context;
        this.resolver = (VariableResolverImpl)context.getVariableResolver();
        if (this.isFirstInit) {
            this.firstInit(context);
        }
        this.query = null;
    }

    protected void firstInit(Context context) {
        this.entityName = context.getEntityAttribute("name");
        String s = context.getEntityAttribute(ON_ERROR);
        if (s != null) {
            this.onError = s;
        }
        this.isFirstInit = false;
    }

    protected Map<String, Object> getNext() {
        try {
            if (this.rowIterator == null) {
                return null;
            }
            if (this.rowIterator.hasNext()) {
                return this.rowIterator.next();
            }
            this.query = null;
            this.rowIterator = null;
            return null;
        }
        catch (Exception e) {
            log.error("getNext() failed for query '" + this.query + "'", (Throwable)e);
            this.query = null;
            this.rowIterator = null;
            DataImportHandlerException.wrapAndThrow(400, e);
            return null;
        }
    }

    @Override
    public Map<String, Object> nextModifiedRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextDeletedRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextModifiedParentRowKey() {
        return null;
    }

    @Override
    public Map<String, Object> nextRow() {
        return null;
    }

    @Override
    public void destroy() {
    }

    protected void cacheInit() {
        if (this.simpleCache != null || this.cacheWithWhereClause != null) {
            return;
        }
        String where = this.context.getEntityAttribute("where");
        String cacheKey = this.context.getEntityAttribute(CACHE_KEY);
        String lookupKey = this.context.getEntityAttribute(CACHE_LOOKUP);
        if (cacheKey != null && lookupKey == null) {
            throw new DataImportHandlerException(500, "'cacheKey' is specified for the entity " + this.entityName + " but 'cacheLookup' is missing");
        }
        if (where == null && cacheKey == null) {
            this.simpleCache = new HashMap<String, List<Map<String, Object>>>();
        } else {
            if (where != null) {
                String[] splits = where.split("=");
                this.cachePk = splits[0];
                this.cacheVariableName = splits[1].trim();
            } else {
                this.cachePk = cacheKey;
                this.cacheVariableName = lookupKey;
            }
            this.cacheWithWhereClause = new HashMap<String, Map<Object, List<Map<String, Object>>>>();
        }
    }

    protected Map<String, Object> getIdCacheData(String query) {
        Map<Object, List<Map<String, Object>>> rowIdVsRows = this.cacheWithWhereClause.get(query);
        List<Map<String, Object>> rows = null;
        Object key = this.resolver.resolve(this.cacheVariableName);
        if (key == null) {
            throw new DataImportHandlerException(400, "The cache lookup value : " + this.cacheVariableName + " is resolved to be null in the entity :" + this.context.getEntityAttribute("name"));
        }
        if (rowIdVsRows != null) {
            rows = rowIdVsRows.get(key);
            if (rows == null) {
                return null;
            }
            this.dataSourceRowCache = new ArrayList<Map<String, Object>>(rows);
            return this.getFromRowCacheTransformed();
        }
        rows = this.getAllNonCachedRows();
        if (rows.isEmpty()) {
            return null;
        }
        rowIdVsRows = new HashMap<Object, List<Map<String, Object>>>();
        for (Map<String, Object> row : rows) {
            Object k = row.get(this.cachePk);
            if (k == null) {
                throw new DataImportHandlerException(400, "No value available for the cache key : " + this.cachePk + " in the entity : " + this.context.getEntityAttribute("name"));
            }
            if (!k.getClass().equals(key.getClass())) {
                throw new DataImportHandlerException(400, "The key in the cache type : " + k.getClass().getName() + "is not same as the lookup value type " + key.getClass().getName() + " in the entity " + this.context.getEntityAttribute("name"));
            }
            if (rowIdVsRows.get(k) == null) {
                rowIdVsRows.put(k, new ArrayList());
            }
            rowIdVsRows.get(k).add(row);
        }
        this.cacheWithWhereClause.put(query, rowIdVsRows);
        if (!rowIdVsRows.containsKey(key)) {
            return null;
        }
        this.dataSourceRowCache = new ArrayList<Map<String, Object>>((Collection)rowIdVsRows.get(key));
        if (this.dataSourceRowCache.isEmpty()) {
            this.dataSourceRowCache = null;
            return null;
        }
        return this.getFromRowCacheTransformed();
    }

    protected List<Map<String, Object>> getAllNonCachedRows() {
        return Collections.EMPTY_LIST;
    }

    protected Map<String, Object> getSimpleCacheData(String query) {
        List<Map<String, Object>> rows = this.simpleCache.get(query);
        if (rows != null) {
            this.dataSourceRowCache = new ArrayList<Map<String, Object>>(rows);
            return this.getFromRowCacheTransformed();
        }
        rows = this.getAllNonCachedRows();
        if (rows.isEmpty()) {
            return null;
        }
        this.dataSourceRowCache = new ArrayList<Map<String, Object>>(rows);
        this.simpleCache.put(query, rows);
        return this.getFromRowCacheTransformed();
    }

    protected Map<String, Object> getFromRowCacheTransformed() {
        Map<String, Object> r = this.dataSourceRowCache.remove(0);
        if (this.dataSourceRowCache.isEmpty()) {
            this.dataSourceRowCache = null;
        }
        return r;
    }
}

