/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Properties;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorWrapper;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldReaderDataSource
extends DataSource<Reader> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldReaderDataSource.class);
    protected VariableResolver vr;
    protected String dataField;
    private String encoding;
    private EntityProcessorWrapper entityProcessor;

    @Override
    public void init(Context context, Properties initProps) {
        this.dataField = context.getEntityAttribute("dataField");
        this.encoding = context.getEntityAttribute("encoding");
        this.entityProcessor = (EntityProcessorWrapper)context.getEntityProcessor();
    }

    @Override
    public Reader getData(String query) {
        Object o = this.entityProcessor.getVariableResolver().resolve(this.dataField);
        if (o == null) {
            throw new DataImportHandlerException(500, "No field available for name : " + this.dataField);
        }
        if (o instanceof String) {
            return new StringReader((String)o);
        }
        if (o instanceof Clob) {
            Clob clob = (Clob)o;
            try {
                return FieldReaderDataSource.readCharStream(clob);
            }
            catch (Exception e) {
                LOG.info("Unable to get data from CLOB");
                return null;
            }
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            try {
                Method m = blob.getClass().getDeclaredMethod("getBinaryStream", new Class[0]);
                if (Modifier.isPublic(m.getModifiers())) {
                    return this.getReader(m, blob);
                }
                m.setAccessible(true);
                return this.getReader(m, blob);
            }
            catch (Exception e) {
                LOG.info("Unable to get data from BLOB");
                return null;
            }
        }
        return new StringReader(o.toString());
    }

    static Reader readCharStream(Clob clob) {
        try {
            Method m = clob.getClass().getDeclaredMethod("getCharacterStream", new Class[0]);
            if (Modifier.isPublic(m.getModifiers())) {
                return (Reader)m.invoke((Object)clob, new Object[0]);
            }
            m.setAccessible(true);
            return (Reader)m.invoke((Object)clob, new Object[0]);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to get reader from clob");
            return null;
        }
    }

    private Reader getReader(Method m, Blob blob) throws IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        InputStream is = (InputStream)m.invoke((Object)blob, new Object[0]);
        if (this.encoding == null) {
            return new InputStreamReader(is);
        }
        return new InputStreamReader(is, this.encoding);
    }

    @Override
    public void close() {
    }
}

