/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.Transformer;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogTransformer
extends Transformer {
    Logger LOG = LoggerFactory.getLogger(LogTransformer.class);
    public static final String LOG_TEMPLATE = "logTemplate";
    public static final String LOG_LEVEL = "logLevel";

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        VariableResolver vr = context.getVariableResolver();
        String expr = context.getEntityAttribute(LOG_TEMPLATE);
        String level = vr.replaceTokens(context.getEntityAttribute(LOG_LEVEL));
        if (expr == null || level == null) {
            return row;
        }
        if ("info".equals(level)) {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info(vr.replaceTokens(expr));
            }
        } else if ("trace".equals(level)) {
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace(vr.replaceTokens(expr));
            }
        } else if ("warn".equals(level)) {
            if (this.LOG.isWarnEnabled()) {
                this.LOG.warn(vr.replaceTokens(expr));
            }
        } else if ("error".equals(level)) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error(vr.replaceTokens(expr));
            }
        } else if ("debug".equals(level) && this.LOG.isDebugEnabled()) {
            this.LOG.debug(vr.replaceTokens(expr));
        }
        return row;
    }
}

