/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.poi.hwpf.model.HDFType;
import org.apache.poi.hwpf.model.UPX;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public final class StyleDescription
implements HDFType {
    private static final int PARAGRAPH_STYLE = 1;
    private static final int CHARACTER_STYLE = 2;
    private int _istd;
    private int _baseLength;
    private short _infoShort;
    private static BitField _sti = BitFieldFactory.getInstance((int)4095);
    private static BitField _fScratch = BitFieldFactory.getInstance((int)4096);
    private static BitField _fInvalHeight = BitFieldFactory.getInstance((int)8192);
    private static BitField _fHasUpe = BitFieldFactory.getInstance((int)16384);
    private static BitField _fMassCopy = BitFieldFactory.getInstance((int)32768);
    private short _infoShort2;
    private static BitField _styleTypeCode = BitFieldFactory.getInstance((int)15);
    private static BitField _baseStyle = BitFieldFactory.getInstance((int)65520);
    private short _infoShort3;
    private static BitField _numUPX = BitFieldFactory.getInstance((int)15);
    private static BitField _nextStyle = BitFieldFactory.getInstance((int)65520);
    private short _bchUpe;
    private short _infoShort4;
    private static BitField _fAutoRedef = BitFieldFactory.getInstance((int)1);
    private static BitField _fHidden = BitFieldFactory.getInstance((int)2);
    UPX[] _upxs;
    String _name;
    ParagraphProperties _pap;
    CharacterProperties _chp;

    public StyleDescription() {
    }

    public StyleDescription(byte[] std, int baseLength, int offset, boolean word9) {
        int grupxStart;
        this._baseLength = baseLength;
        int nameStart = offset + baseLength;
        this._infoShort = LittleEndian.getShort((byte[])std, (int)offset);
        this._infoShort2 = LittleEndian.getShort((byte[])std, (int)(offset += 2));
        this._infoShort3 = LittleEndian.getShort((byte[])std, (int)(offset += 2));
        this._bchUpe = LittleEndian.getShort((byte[])std, (int)(offset += 2));
        this._infoShort4 = LittleEndian.getShort((byte[])std, (int)(offset += 2));
        offset += 2;
        short nameLength = 0;
        int multiplier = 1;
        if (word9) {
            nameLength = LittleEndian.getShort((byte[])std, (int)nameStart);
            multiplier = 2;
            nameStart += 2;
        } else {
            nameLength = std[nameStart];
        }
        try {
            this._name = new String(std, nameStart, nameLength * multiplier, "UTF-16LE");
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
        int varOffset = grupxStart = (nameLength + 1) * multiplier + nameStart;
        int numUPX = _numUPX.getValue((int)this._infoShort3);
        this._upxs = new UPX[numUPX];
        for (int x = 0; x < numUPX; ++x) {
            short upxSize = LittleEndian.getShort((byte[])std, (int)varOffset);
            byte[] upx = new byte[upxSize];
            System.arraycopy(std, varOffset += 2, upx, 0, upxSize);
            this._upxs[x] = new UPX(upx);
            varOffset += upxSize;
            if (upxSize % 2 != 1) continue;
            ++varOffset;
        }
    }

    public int getBaseStyle() {
        return _baseStyle.getValue((int)this._infoShort2);
    }

    public byte[] getCHPX() {
        switch (_styleTypeCode.getValue((int)this._infoShort2)) {
            case 1: {
                if (this._upxs.length > 1) {
                    return this._upxs[1].getUPX();
                }
                return null;
            }
            case 2: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    public byte[] getPAPX() {
        switch (_styleTypeCode.getValue((int)this._infoShort2)) {
            case 1: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    public ParagraphProperties getPAP() {
        return this._pap;
    }

    public CharacterProperties getCHP() {
        return this._chp;
    }

    void setPAP(ParagraphProperties pap) {
        this._pap = pap;
    }

    void setCHP(CharacterProperties chp) {
        this._chp = chp;
    }

    public String getName() {
        return this._name;
    }

    public byte[] toByteArray() {
        int x;
        int size = this._baseLength + 2 + (this._name.length() + 1) * 2;
        size += this._upxs[0].size() + 2;
        for (int x2 = 1; x2 < this._upxs.length; ++x2) {
            size += this._upxs[x2 - 1].size() % 2;
            size += this._upxs[x2].size() + 2;
        }
        byte[] buf = new byte[size];
        int offset = 0;
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this._infoShort);
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)this._infoShort2);
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)this._infoShort3);
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)this._bchUpe);
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)this._infoShort4);
        offset = this._baseLength;
        char[] letters = this._name.toCharArray();
        LittleEndian.putShort((byte[])buf, (int)this._baseLength, (short)((short)letters.length));
        offset += 2;
        for (x = 0; x < letters.length; ++x) {
            LittleEndian.putShort((byte[])buf, (int)offset, (short)((short)letters[x]));
            offset += 2;
        }
        offset += 2;
        for (x = 0; x < this._upxs.length; ++x) {
            short upxSize = (short)this._upxs[x].size();
            LittleEndian.putShort((byte[])buf, (int)offset, (short)upxSize);
            System.arraycopy(this._upxs[x].getUPX(), 0, buf, offset += 2, upxSize);
            offset += upxSize + upxSize % 2;
        }
        return buf;
    }

    public boolean equals(Object o) {
        StyleDescription sd = (StyleDescription)o;
        if (sd._infoShort == this._infoShort && sd._infoShort2 == this._infoShort2 && sd._infoShort3 == this._infoShort3 && sd._bchUpe == this._bchUpe && sd._infoShort4 == this._infoShort4 && this._name.equals(sd._name)) {
            return Arrays.equals(this._upxs, sd._upxs);
        }
        return false;
    }
}

