/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.csv.filters;

import java.io.IOException;
import java.util.regex.Pattern;
import jp.sf.orangesignal.csv.filters.BeanExpression;
import jp.sf.orangesignal.csv.filters.BeanExpressionUtils;

public class BeanRegexExpression
extends BeanExpression {
    private Pattern pattern;

    protected BeanRegexExpression(String name, String pattern) {
        this(name, pattern, 0);
    }

    protected BeanRegexExpression(String name, String pattern, boolean ignoreCase) {
        this(name, pattern, ignoreCase ? 2 : 0);
    }

    protected BeanRegexExpression(String name, String pattern, int flags) {
        super(name);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = Pattern.compile(pattern, flags);
    }

    protected BeanRegexExpression(String name, Pattern pattern) {
        super(name);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null");
        }
        this.pattern = pattern;
    }

    @Override
    public boolean accept(Object bean) throws IOException {
        return BeanExpressionUtils.regex(bean, this.name, this.pattern);
    }
}

