/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class DelegatingCollector
extends Collector {
    static int setLastDelegateCount;
    protected Collector delegate;
    protected Scorer scorer;
    protected IndexReader reader;
    protected int docBase;

    public Collector getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Collector delegate) {
        this.delegate = delegate;
    }

    public void setLastDelegate(Collector delegate) {
        DelegatingCollector ptr = this;
        while (ptr.getDelegate() instanceof DelegatingCollector) {
            ptr = (DelegatingCollector)ptr.getDelegate();
        }
        ptr.setDelegate(delegate);
        ++setLastDelegateCount;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        this.delegate.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.reader = reader;
        this.docBase = docBase;
        this.delegate.setNextReader(reader, docBase);
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.delegate.acceptsDocsOutOfOrder();
    }
}

