/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractFirstPassGroupingCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermFirstPassGroupingCollector
extends AbstractFirstPassGroupingCollector<String> {
    private FieldCache.StringIndex index;
    private String groupField;

    public TermFirstPassGroupingCollector(String groupField, Sort groupSort, int topNGroups) throws IOException {
        super(groupSort, topNGroups);
        this.groupField = groupField;
    }

    @Override
    protected String getDocGroupValue(int doc) {
        int ord = this.index.order[doc];
        return ord == 0 ? null : this.index.lookup[ord];
    }

    @Override
    protected String copyDocGroupValue(String groupValue, String reuse) {
        return groupValue;
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        super.setNextReader(reader, docBase);
        this.index = FieldCache.DEFAULT.getStringIndex(reader, this.groupField);
    }
}

