/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.dbflute.helper;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.seasar.robot.dbflute.helper.StringKeyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSet
implements Set<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Object DUMMY_VALUE = new SerializableDummyObject();
    protected final StringKeyMap<Object> _stringKeyMap;

    protected StringSet(boolean removeUnderscore, boolean order, boolean concurrent) {
        if (order && concurrent) {
            String msg = "The 'order' and 'concurrent' should not be both true at the same time!";
            throw new IllegalStateException(msg);
        }
        this._stringKeyMap = concurrent ? (removeUnderscore ? StringKeyMap.createAsFlexibleConcurrent() : StringKeyMap.createAsCaseInsensitiveConcurrent()) : (order ? (removeUnderscore ? StringKeyMap.createAsFlexibleOrdered() : StringKeyMap.createAsCaseInsensitiveOrdered()) : (removeUnderscore ? StringKeyMap.createAsFlexible() : StringKeyMap.createAsCaseInsensitive()));
    }

    public static StringSet createAsCaseInsensitive() {
        return new StringSet(false, false, false);
    }

    public static StringSet createAsCaseInsensitiveConcurrent() {
        return new StringSet(false, false, true);
    }

    public static StringSet createAsCaseInsensitiveOrdered() {
        return new StringSet(false, true, false);
    }

    public static StringSet createAsFlexible() {
        return new StringSet(true, false, false);
    }

    public static StringSet createAsFlexibleConcurrent() {
        return new StringSet(true, false, true);
    }

    public static StringSet createAsFlexibleOrdered() {
        return new StringSet(true, true, false);
    }

    @Override
    public boolean add(String value) {
        return this._stringKeyMap.put(value, DUMMY_VALUE) == null;
    }

    @Override
    public boolean remove(Object value) {
        return this._stringKeyMap.remove(value) != null;
    }

    @Override
    public boolean contains(Object value) {
        return this._stringKeyMap.containsKey(value);
    }

    @Override
    public void clear() {
        this._stringKeyMap.clear();
    }

    @Override
    public int size() {
        return this._stringKeyMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._stringKeyMap.isEmpty();
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean success = false;
        for (String string : c) {
            if (!this.add(string)) continue;
            success = true;
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean success = false;
        for (Object s : c) {
            if (!this.remove(s)) continue;
            success = true;
        }
        return success;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object s : c) {
            if (!this.contains(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this._stringKeyMap.keySet().iterator();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean success = false;
        for (Object s : c) {
            if (this.contains(s) || !this.remove(s)) continue;
            success = true;
        }
        return success;
    }

    @Override
    public Object[] toArray() {
        return this._stringKeyMap.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._stringKeyMap.keySet().toArray(a);
    }

    public boolean equalsUnderCharOption(StringSet set) {
        if (set == null) {
            return false;
        }
        if (this.size() != set.size()) {
            return false;
        }
        return this._stringKeyMap.equalsUnderCharOption(set._stringKeyMap);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StringSet) {
            StringSet set = (StringSet)obj;
            if (this.size() != set.size()) {
                return false;
            }
            return this._stringKeyMap.equals(set._stringKeyMap);
        }
        if (obj instanceof Set) {
            return ((Object)this._stringKeyMap.keySet()).equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this._stringKeyMap.keySet()).hashCode();
    }

    public String toString() {
        return this._stringKeyMap.keySet().toString();
    }

    protected static class SerializableDummyObject
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected SerializableDummyObject() {
        }
    }
}

