/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TextDetector;
import org.apache.tika.detect.XmlRootExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.mime.Patterns;

public final class MimeTypes
implements Detector,
Serializable {
    private static final long serialVersionUID = -1350863170146349036L;
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final String PLAIN_TEXT = "text/plain";
    public static final String XML = "application/xml";
    private final MimeType rootMimeType;
    private final MimeType textMimeType;
    private final MimeType xmlMimeType;
    private final MediaTypeRegistry registry = new MediaTypeRegistry();
    private final Map<MediaType, MimeType> types = new HashMap<MediaType, MimeType>();
    private Patterns patterns = new Patterns(this.registry);
    private SortedSet<Magic> magics = new TreeSet<Magic>();
    private SortedSet<MimeType> xmls = new TreeSet<MimeType>();

    public MimeTypes() {
        this.rootMimeType = new MimeType(MediaType.OCTET_STREAM);
        this.textMimeType = new MimeType(MediaType.TEXT_PLAIN);
        this.xmlMimeType = new MimeType(MediaType.APPLICATION_XML);
        this.add(this.rootMimeType);
        this.add(this.textMimeType);
        this.add(this.xmlMimeType);
    }

    public MimeType getMimeType(File file) {
        return this.getMimeType(file.getName());
    }

    public MimeType getMimeType(URL url) {
        return this.getMimeType(url.getPath());
    }

    public MimeType getMimeType(String name) {
        MimeType type = this.patterns.matches(name);
        if (type != null) {
            return type;
        }
        type = this.patterns.matches(name.toLowerCase(Locale.ENGLISH));
        if (type != null) {
            return type;
        }
        return this.rootMimeType;
    }

    public MimeType getMimeType(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data is missing");
        }
        if (data.length == 0) {
            return this.rootMimeType;
        }
        MimeType result = null;
        for (Magic magic : this.magics) {
            if (!magic.eval(data)) continue;
            result = magic.getType();
            break;
        }
        if (result != null) {
            if (XML.equals(result.getName()) || "text/html".equals(result.getName())) {
                XmlRootExtractor extractor = new XmlRootExtractor();
                QName rootElement = extractor.extractRootElement(data);
                if (rootElement != null) {
                    for (MimeType type : this.xmls) {
                        if (!type.matchesXML(rootElement.getNamespaceURI(), rootElement.getLocalPart())) continue;
                        result = type;
                        break;
                    }
                } else if (XML.equals(result.getName())) {
                    result = this.textMimeType;
                }
            }
            return result;
        }
        try {
            TextDetector detector = new TextDetector();
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            return this.forName(detector.detect(stream, new Metadata()).toString());
        }
        catch (Exception e) {
            return this.rootMimeType;
        }
    }

    public MimeType getMimeType(InputStream stream) throws IOException {
        return this.getMimeType(this.readMagicHeader(stream));
    }

    private byte[] readMagicHeader(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream is missing");
        }
        byte[] bytes = new byte[this.getMinLength()];
        int totalRead = 0;
        int lastRead = stream.read(bytes);
        while (lastRead != -1) {
            if ((totalRead += lastRead) == bytes.length) {
                return bytes;
            }
            lastRead = stream.read(bytes, totalRead, bytes.length - totalRead);
        }
        byte[] shorter = new byte[totalRead];
        System.arraycopy(bytes, 0, shorter, 0, totalRead);
        return shorter;
    }

    public String getType(String typeName, String url, byte[] data) {
        try {
            Metadata metadata = new Metadata();
            if (url != null) {
                metadata.set("resourceName", url);
            }
            if (typeName != null) {
                metadata.set("Content-Type", typeName);
            }
            return this.detect(new ByteArrayInputStream(data), metadata).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("ByteArrayInputStream throws an IOException!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType(URL url) throws IOException {
        InputStream stream = url.openStream();
        try {
            Metadata metadata = new Metadata();
            metadata.set("resourceName", url.toString());
            String string = this.detect(stream, metadata).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    public MimeType getMimeType(String name, byte[] data) {
        MimeType dataType = this.getMimeType(data);
        MimeType nameType = this.getMimeType(name);
        if (this.registry.isSpecializationOf(nameType.getType(), dataType.getType())) {
            return nameType;
        }
        return dataType;
    }

    public MimeType getMimeType(String name, InputStream stream) throws IOException {
        return this.getMimeType(name, this.readMagicHeader(stream));
    }

    public synchronized MimeType forName(String name) throws MimeTypeException {
        MediaType type = MediaType.parse(name);
        if (type != null) {
            MimeType mime = this.types.get(this.registry.normalize(type));
            if (mime == null) {
                mime = new MimeType(type);
                this.add(mime);
                this.types.put(type, mime);
            }
            return mime;
        }
        throw new MimeTypeException("Invalid media type name: " + name);
    }

    public synchronized void setSuperType(MimeType type, MediaType parent) {
        this.registry.addSuperType(type.getType(), parent);
    }

    synchronized void addAlias(MimeType type, MediaType alias) {
        this.registry.addAlias(type.getType(), alias);
    }

    public void addPattern(MimeType type, String pattern) throws MimeTypeException {
        this.addPattern(type, pattern, false);
    }

    public void addPattern(MimeType type, String pattern, boolean isRegex) throws MimeTypeException {
        this.patterns.add(pattern, isRegex, type);
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.registry;
    }

    public int getMinLength() {
        return 8192;
    }

    void add(MimeType type) {
        this.registry.addType(type.getType());
        this.types.put(type.getType(), type);
        if (type.hasMagic()) {
            this.magics.addAll(Arrays.asList(type.getMagics()));
        }
        if (type.hasRootXML()) {
            this.xmls.add(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        String typeName;
        MediaType hint;
        String resourceName;
        MediaType type = MediaType.OCTET_STREAM;
        if (input != null) {
            input.mark(this.getMinLength());
            try {
                byte[] prefix = this.readMagicHeader(input);
                type = this.getMimeType(prefix).getType();
            }
            finally {
                input.reset();
            }
        }
        if ((resourceName = metadata.get("resourceName")) != null) {
            String name = null;
            try {
                int slash;
                URI uri = new URI(resourceName);
                String path = uri.getPath();
                if (path != null && (slash = path.lastIndexOf(47)) + 1 < path.length()) {
                    name = path.substring(slash + 1);
                }
            }
            catch (URISyntaxException e) {
                name = resourceName;
            }
            if (name != null && this.registry.isSpecializationOf(hint = this.getMimeType(name).getType(), type)) {
                type = hint;
            }
        }
        if ((typeName = metadata.get("Content-Type")) != null) {
            try {
                hint = this.forName(typeName).getType();
                if (this.registry.isSpecializationOf(hint, type)) {
                    type = hint;
                }
            }
            catch (MimeTypeException e) {
                // empty catch block
            }
        }
        return type;
    }

    public static MimeTypes getDefaultMimeTypes() {
        try {
            return MimeTypesFactory.create("tika-mimetypes.xml");
        }
        catch (MimeTypeException e) {
            throw new RuntimeException("Unable to read default mimetypes", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read default mimetypes", e);
        }
    }
}

