/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdfwriter.COSStandardOutputStream;
import org.apache.pdfbox.pdfwriter.COSWriterXRefEntry;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.persistence.util.COSObjectKey;
import org.apache.pdfbox.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSWriter
implements ICOSVisitor {
    public static final byte[] DICT_OPEN = StringUtil.getBytes("<<");
    public static final byte[] DICT_CLOSE = StringUtil.getBytes(">>");
    public static final byte[] SPACE = StringUtil.getBytes(" ");
    public static final byte[] COMMENT = StringUtil.getBytes("%");
    public static final byte[] VERSION = StringUtil.getBytes("PDF-1.4");
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] EOF = StringUtil.getBytes("%%EOF");
    public static final byte[] REFERENCE = StringUtil.getBytes("R");
    public static final byte[] XREF = StringUtil.getBytes("xref");
    public static final byte[] XREF_FREE = StringUtil.getBytes("f");
    public static final byte[] XREF_USED = StringUtil.getBytes("n");
    public static final byte[] TRAILER = StringUtil.getBytes("trailer");
    public static final byte[] STARTXREF = StringUtil.getBytes("startxref");
    public static final byte[] OBJ = StringUtil.getBytes("obj");
    public static final byte[] ENDOBJ = StringUtil.getBytes("endobj");
    public static final byte[] ARRAY_OPEN = StringUtil.getBytes("[");
    public static final byte[] ARRAY_CLOSE = StringUtil.getBytes("]");
    public static final byte[] STREAM = StringUtil.getBytes("stream");
    public static final byte[] ENDSTREAM = StringUtil.getBytes("endstream");
    private NumberFormat formatXrefOffset = new DecimalFormat("0000000000");
    private NumberFormat formatXrefGeneration = new DecimalFormat("00000");
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private OutputStream output;
    private COSStandardOutputStream standardOutput;
    private long startxref = 0L;
    private long number = 0L;
    private Map<COSBase, COSObjectKey> objectKeys = new Hashtable<COSBase, COSObjectKey>();
    private LinkedList xRefEntries = new LinkedList();
    private LinkedList<COSBase> objectsToWrite = new LinkedList();
    private HashSet<COSBase> objectsToWriteSet = new HashSet();
    private Set<COSBase> writtenObjects = new HashSet<COSBase>();
    private Set<COSBase> actualsAdded = new HashSet<COSBase>();
    private COSObjectKey currentObjectKey = null;
    private PDDocument document = null;
    private boolean willEncrypt = false;

    public COSWriter(OutputStream os) {
        this.setOutput(os);
        this.setStandardOutput(new COSStandardOutputStream(this.getOutput()));
        this.formatDecimal.setMaximumFractionDigits(10);
        this.formatDecimal.setGroupingUsed(false);
    }

    protected void addXRefEntry(COSWriterXRefEntry entry) {
        this.getXRefEntries().add(entry);
    }

    public void close() throws IOException {
        if (this.getStandardOutput() != null) {
            this.getStandardOutput().close();
        }
        if (this.getOutput() != null) {
            this.getOutput().close();
        }
    }

    protected long getNumber() {
        return this.number;
    }

    public Map<COSBase, COSObjectKey> getObjectKeys() {
        return this.objectKeys;
    }

    protected OutputStream getOutput() {
        return this.output;
    }

    protected COSStandardOutputStream getStandardOutput() {
        return this.standardOutput;
    }

    protected long getStartxref() {
        return this.startxref;
    }

    protected List getXRefEntries() {
        return this.xRefEntries;
    }

    protected void setNumber(long newNumber) {
        this.number = newNumber;
    }

    private void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    private void setStandardOutput(COSStandardOutputStream newStandardOutput) {
        this.standardOutput = newStandardOutput;
    }

    protected void setStartxref(long newStartxref) {
        this.startxref = newStartxref;
    }

    protected void doWriteBody(COSDocument doc) throws IOException, COSVisitorException {
        COSBase nextObject;
        COSDictionary trailer = doc.getTrailer();
        COSDictionary root = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
        COSDictionary info = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
        COSDictionary encrypt = (COSDictionary)trailer.getDictionaryObject(COSName.ENCRYPT);
        if (root != null) {
            this.addObjectToWrite(root);
        }
        if (info != null) {
            this.addObjectToWrite(info);
        }
        while (this.objectsToWrite.size() > 0) {
            nextObject = this.objectsToWrite.removeFirst();
            this.objectsToWriteSet.remove(nextObject);
            this.doWriteObject(nextObject);
        }
        this.willEncrypt = false;
        if (encrypt != null) {
            this.addObjectToWrite(encrypt);
        }
        while (this.objectsToWrite.size() > 0) {
            nextObject = this.objectsToWrite.removeFirst();
            this.objectsToWriteSet.remove(nextObject);
            this.doWriteObject(nextObject);
        }
    }

    private void addObjectToWrite(COSBase object) {
        COSBase actual = object;
        if (actual instanceof COSObject) {
            actual = ((COSObject)actual).getObject();
        }
        if (!(this.writtenObjects.contains(object) || this.objectsToWriteSet.contains(object) || this.actualsAdded.contains(actual))) {
            this.objectsToWrite.add(object);
            this.objectsToWriteSet.add(object);
            if (actual != null) {
                this.actualsAdded.add(actual);
            }
        }
    }

    public void doWriteObject(COSBase obj) throws COSVisitorException {
        try {
            this.writtenObjects.add(obj);
            this.currentObjectKey = this.getObjectKey(obj);
            this.addXRefEntry(new COSWriterXRefEntry(this.getStandardOutput().getPos(), obj, this.currentObjectKey));
            this.getStandardOutput().write(String.valueOf(this.currentObjectKey.getNumber()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(this.currentObjectKey.getGeneration()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(OBJ);
            this.getStandardOutput().writeEOL();
            obj.accept(this);
            this.getStandardOutput().writeEOL();
            this.getStandardOutput().write(ENDOBJ);
            this.getStandardOutput().writeEOL();
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    protected void doWriteHeader(COSDocument doc) throws IOException {
        this.getStandardOutput().write(doc.getHeaderString().getBytes("ISO-8859-1"));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(COMMENT);
        this.getStandardOutput().write(GARBAGE);
        this.getStandardOutput().writeEOL();
    }

    protected void doWriteTrailer(COSDocument doc) throws IOException, COSVisitorException {
        this.getStandardOutput().write(TRAILER);
        this.getStandardOutput().writeEOL();
        COSDictionary trailer = doc.getTrailer();
        Collections.sort(this.getXRefEntries());
        COSWriterXRefEntry lastEntry = (COSWriterXRefEntry)this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        trailer.setInt(COSName.SIZE, (int)lastEntry.getKey().getNumber() + 1);
        trailer.removeItem(COSName.PREV);
        trailer.accept(this);
        this.getStandardOutput().write(STARTXREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(this.getStartxref()).getBytes("ISO-8859-1"));
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(EOF);
    }

    protected void doWriteXRef(COSDocument doc) throws IOException {
        Collections.sort(this.getXRefEntries());
        COSWriterXRefEntry lastEntry = (COSWriterXRefEntry)this.getXRefEntries().get(this.getXRefEntries().size() - 1);
        this.setStartxref(this.getStandardOutput().getPos());
        this.getStandardOutput().write(XREF);
        this.getStandardOutput().writeEOL();
        this.getStandardOutput().write(String.valueOf(0).getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(String.valueOf(lastEntry.getKey().getNumber() + 1L).getBytes("ISO-8859-1"));
        this.getStandardOutput().writeEOL();
        String offset = this.formatXrefOffset.format(0L);
        String generation = this.formatXrefGeneration.format(65535L);
        this.getStandardOutput().write(offset.getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(generation.getBytes("ISO-8859-1"));
        this.getStandardOutput().write(SPACE);
        this.getStandardOutput().write(XREF_FREE);
        this.getStandardOutput().writeCRLF();
        long lastObjectNumber = 0L;
        for (COSWriterXRefEntry entry : this.getXRefEntries()) {
            while (lastObjectNumber < entry.getKey().getNumber() - 1L) {
                offset = this.formatXrefOffset.format(0L);
                generation = this.formatXrefGeneration.format(65535L);
                this.getStandardOutput().write(offset.getBytes("ISO-8859-1"));
                this.getStandardOutput().write(SPACE);
                this.getStandardOutput().write(generation.getBytes("ISO-8859-1"));
                this.getStandardOutput().write(SPACE);
                this.getStandardOutput().write(XREF_FREE);
                this.getStandardOutput().writeCRLF();
                ++lastObjectNumber;
            }
            lastObjectNumber = entry.getKey().getNumber();
            offset = this.formatXrefOffset.format(entry.getOffset());
            generation = this.formatXrefGeneration.format(entry.getKey().getGeneration());
            this.getStandardOutput().write(offset.getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(generation.getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(entry.isFree() ? XREF_FREE : XREF_USED);
            this.getStandardOutput().writeCRLF();
        }
    }

    private COSObjectKey getObjectKey(COSBase obj) {
        COSBase actual = obj;
        if (actual instanceof COSObject) {
            actual = ((COSObject)obj).getObject();
        }
        COSObjectKey key = null;
        if (actual != null) {
            key = this.objectKeys.get(actual);
        }
        if (key == null) {
            key = this.objectKeys.get(obj);
        }
        if (key == null) {
            this.setNumber(this.getNumber() + 1L);
            key = new COSObjectKey(this.getNumber(), 0L);
            this.objectKeys.put(obj, key);
            if (actual != null) {
                this.objectKeys.put(actual, key);
            }
        }
        return key;
    }

    @Override
    public Object visitFromArray(COSArray obj) throws COSVisitorException {
        try {
            int count = 0;
            this.getStandardOutput().write(ARRAY_OPEN);
            Iterator<COSBase> i = obj.iterator();
            while (i.hasNext()) {
                COSBase current = i.next();
                if (current instanceof COSDictionary) {
                    this.addObjectToWrite(current);
                    this.writeReference(current);
                } else if (current instanceof COSObject) {
                    COSBase subValue = ((COSObject)current).getObject();
                    if (subValue instanceof COSDictionary || subValue == null) {
                        this.addObjectToWrite(current);
                        this.writeReference(current);
                    } else {
                        subValue.accept(this);
                    }
                } else if (current == null) {
                    COSNull.NULL.accept(this);
                } else if (current instanceof COSString) {
                    COSString copy = new COSString(((COSString)current).getString());
                    copy.accept(this);
                } else {
                    current.accept(this);
                }
                ++count;
                if (!i.hasNext()) continue;
                if (count % 10 == 0) {
                    this.getStandardOutput().writeEOL();
                    continue;
                }
                this.getStandardOutput().write(SPACE);
            }
            this.getStandardOutput().write(ARRAY_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromBoolean(COSBoolean obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromDictionary(COSDictionary obj) throws COSVisitorException {
        try {
            this.getStandardOutput().write(DICT_OPEN);
            this.getStandardOutput().writeEOL();
            for (Map.Entry<COSName, COSBase> entry : obj.entrySet()) {
                COSBase value = entry.getValue();
                if (value == null) continue;
                entry.getKey().accept(this);
                this.getStandardOutput().write(SPACE);
                if (value instanceof COSDictionary) {
                    this.addObjectToWrite(value);
                    this.writeReference(value);
                } else if (value instanceof COSObject) {
                    COSBase subValue = ((COSObject)value).getObject();
                    if (subValue instanceof COSDictionary || subValue == null) {
                        this.addObjectToWrite(value);
                        this.writeReference(value);
                    } else {
                        subValue.accept(this);
                    }
                } else {
                    value.accept(this);
                }
                this.getStandardOutput().writeEOL();
            }
            this.getStandardOutput().write(DICT_CLOSE);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromDocument(COSDocument doc) throws COSVisitorException {
        try {
            this.doWriteHeader(doc);
            this.doWriteBody(doc);
            this.doWriteXRef(doc);
            this.doWriteTrailer(doc);
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromFloat(COSFloat obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromInt(COSInteger obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromName(COSName obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromNull(COSNull obj) throws COSVisitorException {
        try {
            obj.writePDF(this.getStandardOutput());
            return null;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    public void writeReference(COSBase obj) throws COSVisitorException {
        try {
            COSObjectKey key = this.getObjectKey(obj);
            this.getStandardOutput().write(String.valueOf(key.getNumber()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(String.valueOf(key.getGeneration()).getBytes("ISO-8859-1"));
            this.getStandardOutput().write(SPACE);
            this.getStandardOutput().write(REFERENCE);
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromStream(COSStream obj) throws COSVisitorException {
        try {
            if (this.willEncrypt) {
                this.document.getSecurityHandler().encryptStream(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
            }
            InputStream input = obj.getFilteredStream();
            COSObject lengthObject = new COSObject(null);
            obj.setItem(COSName.LENGTH, (COSBase)lengthObject);
            this.visitFromDictionary(obj);
            this.getStandardOutput().write(STREAM);
            this.getStandardOutput().writeCRLF();
            byte[] buffer = new byte[1024];
            int amountRead = 0;
            int totalAmountWritten = 0;
            while ((amountRead = input.read(buffer, 0, 1024)) != -1) {
                this.getStandardOutput().write(buffer, 0, amountRead);
                totalAmountWritten += amountRead;
            }
            lengthObject.setObject(COSInteger.get(totalAmountWritten));
            this.getStandardOutput().writeCRLF();
            this.getStandardOutput().write(ENDSTREAM);
            this.getStandardOutput().writeEOL();
            return null;
        }
        catch (Exception e) {
            throw new COSVisitorException(e);
        }
    }

    @Override
    public Object visitFromString(COSString obj) throws COSVisitorException {
        try {
            if (this.willEncrypt) {
                this.document.getSecurityHandler().decryptString(obj, this.currentObjectKey.getNumber(), this.currentObjectKey.getGeneration());
            }
            obj.writePDF(this.getStandardOutput());
        }
        catch (Exception e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    public void write(COSDocument doc) throws COSVisitorException {
        PDDocument pdDoc = new PDDocument(doc);
        this.write(pdDoc);
    }

    public void write(PDDocument doc) throws COSVisitorException {
        COSDictionary trailer;
        COSDocument cosDoc;
        this.document = doc;
        if (doc.isAllSecurityToBeRemoved()) {
            this.willEncrypt = false;
            cosDoc = doc.getDocument();
            trailer = cosDoc.getTrailer();
            trailer.removeItem(COSName.ENCRYPT);
        } else {
            SecurityHandler securityHandler = this.document.getSecurityHandler();
            if (securityHandler != null) {
                try {
                    securityHandler.prepareDocumentForEncryption(this.document);
                    this.willEncrypt = true;
                }
                catch (IOException e) {
                    throw new COSVisitorException(e);
                }
                catch (CryptographyException e) {
                    throw new COSVisitorException(e);
                }
            } else {
                this.willEncrypt = false;
            }
        }
        cosDoc = this.document.getDocument();
        trailer = cosDoc.getTrailer();
        COSArray idArray = (COSArray)trailer.getDictionaryObject(COSName.ID);
        if (idArray == null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(Long.toString(System.currentTimeMillis()).getBytes("ISO-8859-1"));
                COSDictionary info = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
                if (info != null) {
                    Iterator<COSBase> values = info.getValues().iterator();
                    while (values.hasNext()) {
                        md.update(values.next().toString().getBytes("ISO-8859-1"));
                    }
                }
                idArray = new COSArray();
                COSString id = new COSString(md.digest());
                idArray.add(id);
                idArray.add(id);
                trailer.setItem(COSName.ID, (COSBase)idArray);
            }
            catch (NoSuchAlgorithmException e) {
                throw new COSVisitorException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new COSVisitorException(e);
            }
        }
        cosDoc.accept(this);
    }
}

