/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

public class PostLz5Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 18;
    private static final int Threshold = 3;
    private OutputStream out;
    private byte[] buf;
    private int index;
    private int flagIndex;
    private int flagBit;
    private int position;

    private PostLz5Encoder() {
    }

    public PostLz5Encoder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out");
        }
        this.out = out;
        this.position = 0;
        this.buf = new byte[1024];
        this.index = 0;
        this.flagIndex = 0;
        this.flagBit = 256;
    }

    public void writeCode(int code) throws IOException {
        if (this.flagBit == 256) {
            if (this.buf.length - 17 < this.index) {
                this.out.write(this.buf, 0, this.index);
                this.index = 0;
            }
            this.flagBit = 1;
            this.flagIndex = this.index++;
            this.buf[this.flagIndex] = 0;
        }
        if (code < 256) {
            int n = this.flagIndex;
            this.buf[n] = (byte)(this.buf[n] | this.flagBit);
            this.buf[this.index++] = (byte)code;
            ++this.position;
        } else {
            this.buf[this.index++] = (byte)code;
        }
        this.flagBit <<= 1;
    }

    public void writeOffset(int offset) {
        int pos = this.position - offset - 1 - 18 & 0xFFF;
        int matchlen = this.buf[--this.index] & 0xF;
        this.buf[this.index++] = (byte)pos;
        this.buf[this.index++] = (byte)(pos >> 4 & 0xF0 | matchlen);
        this.position += matchlen + 3;
    }

    public void flush() throws IOException {
        if (this.flagBit == 256) {
            this.out.write(this.buf, 0, this.index);
            this.out.flush();
            this.index = 0;
            this.flagBit = 1;
            this.flagIndex = this.index++;
            this.buf[this.flagIndex] = 0;
        } else {
            this.out.write(this.buf, 0, this.flagIndex);
            this.out.flush();
            System.arraycopy(this.buf, this.flagIndex, this.buf, 0, this.index - this.flagIndex);
            this.index -= this.flagIndex;
            this.flagIndex = 0;
        }
    }

    public void close() throws IOException {
        this.out.write(this.buf, 0, this.index);
        this.out.close();
        this.out = null;
        this.buf = null;
    }

    public int getDictionarySize() {
        return 4096;
    }

    public int getMaxMatch() {
        return 18;
    }

    public int getThreshold() {
        return 3;
    }
}

