/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.bhv.core.command;

import java.util.Map;
import org.seasar.dbflute.bhv.core.SqlExecution;
import org.seasar.dbflute.bhv.core.SqlExecutionCreator;
import org.seasar.dbflute.bhv.core.command.AbstractBehaviorCommand;
import org.seasar.dbflute.bhv.core.execution.SelectSimpleExecution;
import org.seasar.dbflute.bhv.core.supplement.SequenceCache;
import org.seasar.dbflute.bhv.core.supplement.SequenceCacheHandler;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.exception.SequenceCacheIncrementSizeInvalidException;
import org.seasar.dbflute.exception.SequenceSelectIllegalStateException;
import org.seasar.dbflute.outsidesql.OutsideSqlOption;
import org.seasar.dbflute.s2dao.jdbc.TnResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectNextValCommand<RESULT>
extends AbstractBehaviorCommand<RESULT> {
    protected Class<RESULT> _resultType;
    protected DBMeta _dbmeta;
    protected SequenceCacheHandler _sequenceCacheHandler;

    @Override
    public String getCommandName() {
        return "selectNextVal";
    }

    @Override
    public Class<?> getCommandReturnType() {
        return this._resultType;
    }

    @Override
    public boolean isConditionBean() {
        return false;
    }

    @Override
    public boolean isOutsideSql() {
        return false;
    }

    @Override
    public boolean isProcedure() {
        return false;
    }

    @Override
    public boolean isSelect() {
        return true;
    }

    @Override
    public boolean isSelectCount() {
        return false;
    }

    @Override
    public void beforeGettingSqlExecution() {
    }

    @Override
    public void afterExecuting() {
    }

    @Override
    public String buildSqlExecutionKey() {
        this.assertStatus("buildSqlExecutionKey");
        return this._tableDbName + ":" + this.getCommandName() + "()";
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return new SqlExecutionCreator(){

            public SqlExecution createSqlExecution() {
                TnResultSetHandler handler = SelectNextValCommand.this.createDynamicScalarResultSetHandler(SelectNextValCommand.this._resultType);
                return SelectNextValCommand.this.createSelectNextValExecution(handler);
            }
        };
    }

    protected SqlExecution createSelectNextValExecution(TnResultSetHandler handler) {
        this.assertStatus("createSelectNextValExecution");
        DBMeta dbmeta = this._dbmeta;
        this.assertTableHasSequence();
        String sql = this.getSequenceNextValSql();
        this.assertSequenceReturnsNotNull(sql, dbmeta);
        SequenceCache sequenceCache = this.findSequenceCache(dbmeta);
        sql = this.prepareSequenceCache(sql, sequenceCache);
        return this.createSequenceExecution(handler, sql, sequenceCache);
    }

    protected String getSequenceNextValSql() {
        return this._dbmeta.getSequenceNextValSql();
    }

    protected String prepareSequenceCache(String sql, SequenceCache sequenceCache) {
        DBMeta dbmeta = this._dbmeta;
        Integer incrementSize = dbmeta.getSequenceIncrementSize();
        Integer cacheSize = dbmeta.getSequenceCacheSize();
        return this.doPrepareSequenceCache(sql, sequenceCache, incrementSize, cacheSize);
    }

    protected String doPrepareSequenceCache(String sql, SequenceCache sequenceCache, Integer incrementSize, Integer cacheSize) {
        if (sequenceCache != null) {
            DBMeta dbmeta = this._dbmeta;
            if (incrementSize != null) {
                this.assertIncrementSizeNotMinusAndNotZero(incrementSize, dbmeta);
                sql = this._sequenceCacheHandler.filterNextValSql(cacheSize, incrementSize, sql);
            }
        }
        return sql;
    }

    protected void assertTableHasSequence() {
        if (!this._dbmeta.hasSequence()) {
            String msg = "If it uses sequence, the table should be related to a sequence:";
            msg = msg + " table=" + this._dbmeta.getTableDbName() + " sequence=" + this._dbmeta.getSequenceName();
            throw new SequenceSelectIllegalStateException(msg);
        }
    }

    protected void assertSequenceReturnsNotNull(String nextValSql, DBMeta dbmeta) {
        if (nextValSql == null) {
            String msg = "If it uses sequence, SQL for next value should exist:";
            msg = msg + " table=" + dbmeta.getTableDbName() + " sequence=" + dbmeta.getSequenceName();
            throw new SequenceSelectIllegalStateException(msg);
        }
    }

    protected SequenceCache findSequenceCache(DBMeta dbmeta) {
        String tableName = dbmeta.getTableDbName();
        String sequenceName = dbmeta.getSequenceName();
        Integer cacheSize = dbmeta.getSequenceCacheSize();
        Integer incrementSize = dbmeta.getSequenceIncrementSize();
        return this.doFindSequenceCache(tableName, sequenceName, cacheSize, incrementSize);
    }

    protected SequenceCache doFindSequenceCache(String tableName, String sequenceName, Integer cacheSize, Integer incrementSize) {
        return this._sequenceCacheHandler.findSequenceCache(tableName, sequenceName, this._dataSource, this._resultType, cacheSize, incrementSize);
    }

    protected void assertIncrementSizeNotMinusAndNotZero(Integer incrementSize, DBMeta dbmeta) {
        if (incrementSize <= 0) {
            String msg = "The increment size should not be minus or zero if you use sequence cache:";
            msg = msg + " table=" + dbmeta.getTableDbName() + " sequence=" + dbmeta.getSequenceName();
            msg = msg + " cacheSize=" + dbmeta.getSequenceCacheSize();
            msg = msg + " incrementSize=" + dbmeta.getSequenceIncrementSize();
            throw new SequenceCacheIncrementSizeInvalidException(msg);
        }
    }

    protected SelectSimpleExecution createSequenceExecution(TnResultSetHandler handler, String sql, final SequenceCache sequenceCache) {
        Map<String, Class<?>> argNameTypeMap = this.newArgNameTypeMap();
        SelectSimpleExecution cmd = sequenceCache != null ? new SelectSimpleExecution(this._dataSource, this._statementFactory, argNameTypeMap, sql, handler){

            public Object execute(final Object[] args) {
                return sequenceCache.nextval(new SequenceCache.SequenceRealExecutor(){

                    public Object execute() {
                        return this.executeSuperExecute(args);
                    }
                });
            }

            protected Object executeSuperExecute(Object[] args) {
                return super.execute(args);
            }
        } : new SelectSimpleExecution(this._dataSource, this._statementFactory, argNameTypeMap, sql, handler);
        return cmd;
    }

    @Override
    public Object[] getSqlExecutionArgument() {
        this.assertStatus("getSqlExecutionArgument");
        return new Object[0];
    }

    @Override
    public ConditionBean getConditionBean() {
        return null;
    }

    @Override
    public String getOutsideSqlPath() {
        return null;
    }

    @Override
    public OutsideSqlOption getOutsideSqlOption() {
        return null;
    }

    protected void assertStatus(String methodName) {
        this.assertBasicProperty(methodName);
        this.assertComponentProperty(methodName);
        if (this._dbmeta == null) {
            throw new IllegalStateException(this.buildAssertMessage("_dbmeta", methodName));
        }
    }

    public void setResultType(Class<RESULT> resultType) {
        this._resultType = resultType;
    }

    public void setDBMeta(DBMeta dbmeta) {
        this._dbmeta = dbmeta;
    }

    public void setSequenceCacheHandler(SequenceCacheHandler sequenceCacheHandler) {
        this._sequenceCacheHandler = sequenceCacheHandler;
    }
}

