/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.holder.impl;

import java.util.HashMap;
import java.util.LinkedList;
import org.mobylet.core.config.MobyletConfig;
import org.mobylet.core.holder.SessionHolder;
import org.mobylet.core.session.MobyletSession;
import org.mobylet.core.session.MobyletSessionTouchListener;
import org.mobylet.core.util.SingletonUtils;

public class MobyletSessionHolder
implements SessionHolder,
MobyletSessionTouchListener {
    protected HashMap<String, MobyletSession> holder = new HashMap();
    protected LinkedList<MobyletSession> linkedSession = new LinkedList();
    protected int timeSpan = 600000;

    @Override
    public <T> T get(String uid, Class<T> clazz) {
        MobyletSession session = this.getSession(uid);
        if (session != null) {
            return session.get(clazz);
        }
        return null;
    }

    @Override
    public <T> T remove(String uid, Class<T> clazz) {
        MobyletSession session = this.getSession(uid);
        if (session != null) {
            return session.remove(clazz);
        }
        return null;
    }

    @Override
    public <T> void set(String uid, T obj) {
        if (uid != null) {
            MobyletSession session = this.getSession(uid);
            if (session == null) {
                session = new MobyletSession(uid);
                session.setTouchListener(this);
                session.touch();
                this.holder.put(uid, session);
            }
            session.put(obj);
        }
    }

    @Override
    public void invalidate(String uid) {
        MobyletSession session = this.holder.remove(uid);
        this.linkedSession.remove(session);
    }

    protected void processClean() {
        MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
        Long expiredTime = System.currentTimeMillis() - (long)config.getSessionTimeout().intValue() * 60000L;
        MobyletSession session = null;
        while ((session = this.linkedSession.peek()) != null && session.getTouchTime() < expiredTime) {
            this.linkedSession.poll();
        }
    }

    protected MobyletSession getSession(String uid) {
        this.processClean();
        if (uid != null) {
            MobyletSession session = this.holder.remove(uid);
            if (session == null) {
                return null;
            }
            MobyletConfig config = SingletonUtils.get(MobyletConfig.class);
            Long expiredTime = System.currentTimeMillis() - (long)config.getSessionTimeout().intValue() * (long)this.timeSpan;
            if (session.getTouchTime() < expiredTime) {
                this.linkedSession.remove(session);
                return null;
            }
            session.touch();
            this.holder.put(uid, session);
            return session;
        }
        return null;
    }

    @Override
    public void actionTouch(MobyletSession session) {
        if (this.linkedSession.remove(session)) {
            this.linkedSession.add(session);
        }
    }
}

