/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;

public class RequestWriter {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public Collection<ContentStream> getContentStreams(SolrRequest req) throws IOException {
        if (req instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)req;
            if (this.isEmpty(updateRequest)) {
                return null;
            }
            ArrayList<ContentStream> l = new ArrayList<ContentStream>();
            l.add(new LazyContentStream(updateRequest));
            return l;
        }
        return req.getContentStreams();
    }

    private boolean isEmpty(UpdateRequest updateRequest) {
        return this.isNull(updateRequest.getDocuments()) && this.isNull(updateRequest.getDeleteById()) && this.isNull(updateRequest.getDeleteQuery()) && updateRequest.getDocIterator() == null;
    }

    public String getPath(SolrRequest req) {
        return req.getPath();
    }

    public ContentStream getContentStream(UpdateRequest req) throws IOException {
        return new ContentStreamBase.StringStream(req.getXML());
    }

    public void write(SolrRequest request, OutputStream os) throws IOException {
        if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            OutputStreamWriter writer = new OutputStreamWriter(os, UTF_8);
            updateRequest.writeXML(writer);
            writer.flush();
        }
    }

    public String getUpdateContentType() {
        return "application/xml; charset=UTF-8";
    }

    protected boolean isNull(List l) {
        return l == null || l.isEmpty();
    }

    public class LazyContentStream
    implements ContentStream {
        ContentStream contentStream = null;
        UpdateRequest req = null;

        public LazyContentStream(UpdateRequest req) {
            this.req = req;
        }

        private ContentStream getDelegate() {
            if (this.contentStream == null) {
                try {
                    this.contentStream = RequestWriter.this.getContentStream(this.req);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to write xml into a stream", e);
                }
            }
            return this.contentStream;
        }

        @Override
        public String getName() {
            return this.getDelegate().getName();
        }

        @Override
        public String getSourceInfo() {
            return this.getDelegate().getSourceInfo();
        }

        @Override
        public String getContentType() {
            return RequestWriter.this.getUpdateContentType();
        }

        @Override
        public Long getSize() {
            return this.getDelegate().getSize();
        }

        @Override
        public InputStream getStream() throws IOException {
            return this.getDelegate().getStream();
        }

        @Override
        public Reader getReader() throws IOException {
            return this.getDelegate().getReader();
        }

        public void writeTo(OutputStream os) throws IOException {
            RequestWriter.this.write(this.req, os);
        }
    }
}

