/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.junit.runner.Description;

public final class FormattingUtils {
    public static String padTo(int n, String string, String string2) {
        if (string.length() < n) {
            return string;
        }
        string = string2 + string.substring(string.length() - (n - string2.length()));
        return string;
    }

    public static String formatTime(long l) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH).format(new Date(l));
    }

    public static String formatTimestamp(long l) {
        return new SimpleDateFormat("HH:mm:ss.SSS", Locale.US).format(new Date(l));
    }

    public static String formatDurationInSeconds(long l) {
        int n = l >= 100000L ? 0 : (l >= 10000L ? 1 : 2);
        return String.format(Locale.ENGLISH, "%4." + n + "fs", (double)l / 1000.0);
    }

    public static String formatDescription(Description description) {
        return FormattingUtils.formatDescription(description, false);
    }

    public static String formatDescription(Description description, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = description.getClassName();
        if (string != null) {
            if (bl) {
                stringBuilder.append(string);
            } else {
                String[] stringArray = string.split("[\\.]");
                string = stringArray[stringArray.length - 1];
                stringBuilder.append(string);
            }
            if (description.getMethodName() != null) {
                stringBuilder.append(".").append(description.getMethodName());
            } else {
                stringBuilder.append(" (suite)");
            }
        } else if (description.getMethodName() != null) {
            stringBuilder.append(description.getMethodName());
        }
        return stringBuilder.toString();
    }
}

