/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.BigDecimalTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.BigIntegerTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.BooleanTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.ByteTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.CharacterTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.ClassTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.CurrencyTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.DateTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.DoubleTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.EnumTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.FileTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.FloatTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.GregorianCalendarTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.IntegerTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.LocaleTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.LongTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.Matcher;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.ShortTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.StringTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.TimeZoneTransform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.Transform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.URLTransform;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

class PackageMatcher
implements Matcher {
    public Transform match(Class clazz) {
        String string = clazz.getName();
        if (string.startsWith("java.lang")) {
            return this.matchLanguage(clazz);
        }
        if (string.startsWith("java.util")) {
            return this.matchUtility(clazz);
        }
        if (string.startsWith("java.net")) {
            return this.matchURL(clazz);
        }
        if (string.startsWith("java.io")) {
            return this.matchFile(clazz);
        }
        if (string.startsWith("java.sql")) {
            return this.matchSQL(clazz);
        }
        if (string.startsWith("java.math")) {
            return this.matchMath(clazz);
        }
        return this.matchEnum(clazz);
    }

    private Transform matchEnum(Class clazz) {
        if (clazz.isEnum()) {
            return new EnumTransform(clazz);
        }
        return null;
    }

    private Transform matchLanguage(Class clazz) {
        if (clazz == Boolean.class) {
            return new BooleanTransform();
        }
        if (clazz == Integer.class) {
            return new IntegerTransform();
        }
        if (clazz == Long.class) {
            return new LongTransform();
        }
        if (clazz == Double.class) {
            return new DoubleTransform();
        }
        if (clazz == Float.class) {
            return new FloatTransform();
        }
        if (clazz == Short.class) {
            return new ShortTransform();
        }
        if (clazz == Byte.class) {
            return new ByteTransform();
        }
        if (clazz == Character.class) {
            return new CharacterTransform();
        }
        if (clazz == String.class) {
            return new StringTransform();
        }
        if (clazz == Class.class) {
            return new ClassTransform();
        }
        return null;
    }

    private Transform matchMath(Class clazz) {
        if (clazz == BigDecimal.class) {
            return new BigDecimalTransform();
        }
        if (clazz == BigInteger.class) {
            return new BigIntegerTransform();
        }
        return null;
    }

    private Transform matchUtility(Class clazz) {
        if (clazz == java.util.Date.class) {
            return new DateTransform(clazz);
        }
        if (clazz == Locale.class) {
            return new LocaleTransform();
        }
        if (clazz == Currency.class) {
            return new CurrencyTransform();
        }
        if (clazz == GregorianCalendar.class) {
            return new GregorianCalendarTransform();
        }
        if (clazz == TimeZone.class) {
            return new TimeZoneTransform();
        }
        return null;
    }

    private Transform matchSQL(Class clazz) {
        if (clazz == Time.class) {
            return new DateTransform(clazz);
        }
        if (clazz == Date.class) {
            return new DateTransform(clazz);
        }
        if (clazz == Timestamp.class) {
            return new DateTransform(clazz);
        }
        return null;
    }

    private Transform matchFile(Class clazz) {
        if (clazz == File.class) {
            return new FileTransform();
        }
        return null;
    }

    private Transform matchURL(Class clazz) {
        if (clazz == URL.class) {
            return new URLTransform();
        }
        return null;
    }
}

