/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.events.AbstractEvent;
import com.carrotsearch.ant.tasks.junit4.events.EventType;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;

public class BootstrapEvent
extends AbstractEvent {
    private String defaultCharset = Charset.defaultCharset().name();
    private Map systemProperties;
    private String pidString;

    public BootstrapEvent() {
        super(EventType.BOOTSTRAP);
        try {
            this.pidString = ManagementFactory.getRuntimeMXBean().getName();
        }
        catch (Throwable throwable) {
            this.pidString = "<pid acquire exception: " + throwable.toString() + ">";
        }
        this.systemProperties = new TreeMap();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (object == null) continue;
            this.systemProperties.put(object.toString(), object2 != null ? object2.toString() : "");
        }
        this.systemProperties.put("junit4.memory.total", Long.toString(Runtime.getRuntime().totalMemory()));
        this.systemProperties.put("junit4.processors", Long.toString(Runtime.getRuntime().availableProcessors()));
        this.systemProperties.put("junit4.pidString", this.pidString);
    }

    public String getDefaultCharsetName() {
        return this.defaultCharset;
    }

    public Map getSystemProperties() {
        return this.systemProperties;
    }

    public String getPidString() {
        return this.pidString;
    }
}

