/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners;

import com.carrotsearch.ant.tasks.junit4.JUnit4;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.Subscribe;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closeables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedQuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedSuiteResultEvent;
import com.carrotsearch.ant.tasks.junit4.listeners.AggregatedEventListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;

public class ExecutionTimesReport
implements AggregatedEventListener {
    public static final int DEFAULT_HISTORY_LENGTH = 10;
    private File hintsFile;
    private Map hints;
    private int historyLength = 10;
    private JUnit4 outer;

    public void setFile(File file) {
        this.hintsFile = file;
    }

    public void setHistoryLength(int n) {
        if (n < 0) {
            throw new BuildException("History length must be >= 1: " + n);
        }
        this.historyLength = n;
    }

    @Subscribe
    public void onSuiteResult(AggregatedSuiteResultEvent aggregatedSuiteResultEvent) {
        long l = aggregatedSuiteResultEvent.getExecutionTime();
        String string = aggregatedSuiteResultEvent.getDescription().getDisplayName();
        List list = (List)this.hints.get(string);
        if (list == null) {
            list = Lists.newArrayList();
            this.hints.put(string, list);
        }
        list.add(l);
        while (list.size() > this.historyLength) {
            list.remove(0);
        }
    }

    @Subscribe
    public void onEnd(AggregatedQuitEvent aggregatedQuitEvent) {
        try {
            ExecutionTimesReport.writeHints(this.hintsFile, this.hints);
        }
        catch (IOException iOException) {
            this.outer.log("Could not write back the hints file.", iOException, 0);
        }
    }

    @Override
    public void setOuter(JUnit4 jUnit4) {
        if (this.hintsFile == null) {
            throw new BuildException("Execution times listener requires file attribute.");
        }
        try {
            if (this.hintsFile.isFile()) {
                this.hints = ExecutionTimesReport.readHints(this.hintsFile);
            } else {
                if (!this.hintsFile.createNewFile()) {
                    throw new BuildException("Could not create file: " + this.hintsFile.getAbsolutePath());
                }
                this.hints = Maps.newHashMap();
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Could not read or create hints file: " + this.hintsFile.getAbsolutePath(), (Throwable)iOException);
        }
        this.outer = jUnit4;
    }

    public static Map readHints(File file) {
        HashMap hashMap = Maps.newHashMap();
        FileInputStream fileInputStream = new FileInputStream(file);
        ExecutionTimesReport.mergeHints(fileInputStream, hashMap);
        return hashMap;
    }

    public static void mergeHints(InputStream inputStream, Map map) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty() || string.startsWith("#")) continue;
            int n = string.indexOf(61);
            if (n <= 0) {
                throw new IOException("No '=' character on a non-comment line?: " + string);
            }
            String string2 = string.substring(0, n);
            List list = (List)map.get(string2);
            if (list == null) {
                list = Lists.newArrayList();
                map.put(string2, list);
            }
            for (String string3 : string.substring(n + 1).split("[\\,]")) {
                if (string3.isEmpty()) continue;
                list.add(Long.parseLong(string3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHints(File file, Map treeMap) {
        BufferedWriter bufferedWriter = Files.newWriter(file, Charsets.UTF_8);
        try {
            if (!(treeMap instanceof SortedMap)) {
                treeMap = new TreeMap(treeMap);
            }
            Joiner joiner = Joiner.on(',');
            for (Map.Entry entry : treeMap.entrySet()) {
                bufferedWriter.write((String)entry.getKey());
                bufferedWriter.write("=");
                joiner.appendTo(bufferedWriter, (Iterable)entry.getValue());
                bufferedWriter.write("\n");
            }
        }
        finally {
            Closeables.closeQuietly(bufferedWriter);
        }
    }

    public static Map mergeHints(Collection collection, Collection collection2) {
        HashMap hashMap = Maps.newHashMap();
        for (ResourceCollection resourceCollection : collection) {
            Iterator iterator = resourceCollection.iterator();
            while (iterator.hasNext()) {
                InputStream inputStream = null;
                Resource resource = (Resource)iterator.next();
                try {
                    inputStream = resource.getInputStream();
                    ExecutionTimesReport.mergeHints(inputStream, hashMap);
                    if (collection2 == null) continue;
                    hashMap.keySet().retainAll(collection2);
                }
                catch (IOException iOException) {
                    throw new BuildException("Could not read hints from resource: " + resource.getDescription(), (Throwable)iOException);
                }
                finally {
                    Closeables.closeQuietly(inputStream);
                }
            }
        }
        return hashMap;
    }
}

