/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.slave;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.MethodGlobFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.events.BootstrapEvent;
import com.carrotsearch.ant.tasks.junit4.events.Serializer;
import com.carrotsearch.ant.tasks.junit4.events.SuiteFailureEvent;
import com.carrotsearch.ant.tasks.junit4.slave.JvmExit;
import com.carrotsearch.ant.tasks.junit4.slave.OrderedRunNotifier;
import com.carrotsearch.ant.tasks.junit4.slave.RandomAccessFileOutputStream;
import com.carrotsearch.ant.tasks.junit4.slave.RunListenerEmitter;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain$1;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain$2;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain$3;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain$4;
import com.carrotsearch.ant.tasks.junit4.slave.StdInLineIterator;
import com.carrotsearch.ant.tasks.junit4.slave.StreamFlusherDecorator;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;

public class SlaveMain {
    public static final int ERR_EXCEPTION = 240;
    public static final int ERR_NO_JUNIT = 239;
    public static final int ERR_OLD_JUNIT = 238;
    public static final int ERR_OOM = 237;
    static volatile Object lastResortMemory = new byte[0x500000];
    static Class oomClass = OutOfMemoryError.class;
    public static final String OPTION_FREQUENT_FLUSH = "-flush";
    public static final String OPTION_SYSOUTS = "-sysouts";
    public static final String OPTION_STDIN = "-stdin";
    public static final String OPTION_EVENTSFILE = "-eventsfile";
    public static final String SYSPROP_FIRERUNNERFAILURE = SlaveMain.class.getName() + ".fireRunnerFailure";
    private final Serializer serializer;
    private static PrintStream warnings;
    private boolean flushFrequently = false;
    private static boolean multiplexStdStreams;

    public SlaveMain(Serializer serializer) {
        this.serializer = serializer;
    }

    private void execute(Iterator iterator) {
        OrderedRunNotifier orderedRunNotifier = new OrderedRunNotifier();
        Result result = new Result();
        orderedRunNotifier.addListener(result.createListener());
        orderedRunNotifier.addListener(new StreamFlusherDecorator(new SlaveMain$1(this, new RunListenerEmitter(this.serializer))));
        orderedRunNotifier.addListener(new SlaveMain$2(this));
        String string = Strings.emptyToNull(System.getProperty(SysGlobals.SYSPROP_TESTMETHOD()));
        Filter filter = Filter.ALL;
        if (string != null) {
            filter = new MethodGlobFilter(string);
        }
        while (iterator.hasNext()) {
            Class clazz = this.instantiate((String)iterator.next());
            if (clazz == null) continue;
            Request request = Request.aClass((Class)clazz);
            try {
                Runner runner = request.getRunner();
                filter.apply((Object)runner);
                orderedRunNotifier.fireTestRunStarted(runner.getDescription());
                runner.run((RunNotifier)orderedRunNotifier);
                orderedRunNotifier.fireTestRunFinished(result);
            }
            catch (NoTestsRemainException noTestsRemainException) {}
        }
    }

    private Class instantiate(String string) {
        try {
            return Class.forName(string, false, Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            try {
                this.serializer.serialize(new SuiteFailureEvent(new Failure(Description.createSuiteDescription((String)string, (Annotation[])new Annotation[0]), throwable)));
                if (this.flushFrequently) {
                    this.serializer.flush();
                }
            }
            catch (Exception exception) {
                SlaveMain.warn("Could not report failure back to master.", throwable);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 0;
        Serializer serializer = null;
        try {
            Object object;
            ArrayDeque<String> arrayDeque = new ArrayDeque<String>(Arrays.asList(stringArray));
            boolean bl = false;
            File file = null;
            boolean bl2 = false;
            ArrayList arrayList = Lists.newArrayList();
            while (!arrayDeque.isEmpty()) {
                object = arrayDeque.pop();
                if (((String)object).equals(OPTION_FREQUENT_FLUSH)) {
                    bl = true;
                    continue;
                }
                if (((String)object).equals(OPTION_STDIN)) {
                    bl2 = true;
                    continue;
                }
                if (((String)object).equals(OPTION_SYSOUTS)) {
                    multiplexStdStreams = true;
                    continue;
                }
                if (((String)object).equals(OPTION_EVENTSFILE)) {
                    file = new File(arrayDeque.pop());
                    if (!file.isFile() || file.length() <= 0L) continue;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    randomAccessFile.setLength(0L);
                    randomAccessFile.close();
                    continue;
                }
                if (((String)object).startsWith("@")) {
                    arrayDeque.addAll(Arrays.asList(SlaveMain.readArgsFile(((String)object).substring(1))));
                    continue;
                }
                arrayList.add(object);
            }
            if (file == null) {
                throw new IOException("You must specify communication channel for events.");
            }
            object = new RandomAccessFileOutputStream(file);
            int n2 = 8192;
            serializer = new Serializer(new BufferedOutputStream((OutputStream)object, 8192)).serialize(new BootstrapEvent()).flush();
            SlaveMain.redirectStreams(serializer, bl);
            SlaveMain slaveMain = new SlaveMain(serializer);
            slaveMain.flushFrequently = bl;
            StdInLineIterator stdInLineIterator = bl2 ? new StdInLineIterator(slaveMain.serializer) : Collections.emptyList().iterator();
            slaveMain.execute(Iterators.concat(arrayList.iterator(), stdInLineIterator));
            if (System.getProperty(SYSPROP_FIRERUNNERFAILURE) != null) {
                throw new Exception(System.getProperty(SYSPROP_FIRERUNNERFAILURE));
            }
        }
        catch (Throwable throwable) {
            lastResortMemory = null;
            SlaveMain.tryWaitingForGC();
            if (throwable.getClass() == oomClass) {
                n = 237;
                SlaveMain.warn("JVM out of memory.", throwable);
            }
            n = 240;
            SlaveMain.warn("Exception at main loop level.", throwable);
        }
        try {
            if (serializer != null) {
                try {
                    serializer.close();
                }
                catch (Throwable throwable) {
                    SlaveMain.warn("Exception closing serializer.", throwable);
                }
            }
        }
        finally {
            JvmExit.halt(n);
        }
    }

    private static void tryWaitingForGC() {
        long l = System.currentTimeMillis() + 2000L;
        while (System.currentTimeMillis() < l) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readArgsFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).isEmpty() || string2.startsWith("#")) continue;
                arrayList.add(string2);
            }
        }
        finally {
            bufferedReader.close();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void redirectStreams(Serializer serializer, boolean bl) {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        warnings = System.err;
        System.setOut(new PrintStream(new BufferedOutputStream(new SlaveMain$3(printStream, serializer, bl))));
        System.setErr(new PrintStream(new BufferedOutputStream(new SlaveMain$4(printStream2, serializer, bl))));
    }

    public static void warn(String string, Throwable throwable) {
        PrintStream printStream = warnings == null ? System.err : warnings;
        try {
            printStream.print("WARN: ");
            printStream.print(string);
            if (throwable != null) {
                printStream.print(" -> ");
                try {
                    printStream.println(Throwables.getStackTraceAsString(throwable));
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    printStream.print(throwable.getClass().getName());
                    printStream.print(": ");
                    printStream.print(throwable.getMessage());
                    printStream.println(" (stack unavailable; OOM)");
                }
            } else {
                printStream.println();
            }
            printStream.flush();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            printStream.println("ERROR: Couldn't even serialize a warning (out of memory).");
        }
        catch (Throwable throwable2) {
            printStream.println("ERROR: Couldn't even serialize a warning.");
        }
    }

    static /* synthetic */ Serializer access$000(SlaveMain slaveMain) {
        return slaveMain.serializer;
    }

    static /* synthetic */ boolean access$200() {
        return multiplexStdStreams;
    }

    static {
        multiplexStdStreams = false;
    }
}

