/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.gosen.GosenPartOfSpeechStopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class GosenPartOfSpeechStopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private boolean enablePositionIncrements;
    private Set<String> stopTags;

    public void inform(ResourceLoader loader) {
        String stopTagFiles = (String)this.args.get("tags");
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        try {
            CharArraySet cas = this.getWordSet(loader, stopTagFiles, false);
            this.stopTags = new HashSet<String>();
            for (Object element : cas) {
                char[] chars = (char[])element;
                this.stopTags.add(new String(chars));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TokenStream create(TokenStream stream) {
        return new GosenPartOfSpeechStopFilter(this.enablePositionIncrements, stream, this.stopTags);
    }
}

