/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeepWordFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class KeepWordFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet words;
    private boolean ignoreCase;
    private boolean enablePositionIncrements;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.assureMatchVersion();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String wordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        if (wordFiles != null) {
            this.words = this.getWordSet(loader, wordFiles, this.ignoreCase);
        }
    }

    public void setWords(Set<String> words) {
        this.words = new CharArraySet(this.luceneMatchVersion, words, this.ignoreCase);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        if (this.words != null && this.ignoreCase != ignoreCase) {
            this.words = new CharArraySet(this.luceneMatchVersion, this.words, ignoreCase);
        }
        this.ignoreCase = ignoreCase;
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getWords() {
        return this.words;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return this.words == null ? input : new KeepWordFilter(this.enablePositionIncrements, input, this.words);
    }
}

