/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Collections;
import java.util.Iterator;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedData;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.bouncycastle.cms.MacOutputStream;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.MacCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedDataGenerator() {
    }

    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(cMSTypedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData cMSTypedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authenticatedData;
        Object object2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (Object object2 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add((DEREncodable)object2.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString dEROctetString;
            OutputStream outputStream;
            BERConstructedOctetString bERConstructedOctetString;
            TeeOutputStream teeOutputStream;
            try {
                object2 = new ByteArrayOutputStream();
                teeOutputStream = new TeeOutputStream(digestCalculator.getOutputStream(), (OutputStream)object2);
                cMSTypedData.write((OutputStream)teeOutputStream);
                teeOutputStream.close();
                bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object2).toByteArray());
            }
            catch (IOException iOException) {
                throw new CMSException("unable to perform digest calculation: " + iOException.getMessage(), iOException);
            }
            object2 = this.getBaseParameters((DERObjectIdentifier)cMSTypedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            teeOutputStream = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(object2)).toASN1EncodableVector());
            try {
                outputStream = macCalculator.getOutputStream();
                outputStream.write(teeOutputStream.getDEREncoded());
                outputStream.close();
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("exception decoding algorithm parameters.", iOException);
            }
            outputStream = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(object2)).toASN1EncodableVector()) : null;
            ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.data, (DEREncodable)bERConstructedOctetString);
            authenticatedData = new AuthenticatedData(null, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), contentInfo, (ASN1Set)teeOutputStream, (ASN1OctetString)dEROctetString, (ASN1Set)outputStream);
        } else {
            DEROctetString dEROctetString;
            BERConstructedOctetString bERConstructedOctetString;
            TeeOutputStream teeOutputStream;
            try {
                object2 = new ByteArrayOutputStream();
                teeOutputStream = new TeeOutputStream((OutputStream)object2, macCalculator.getOutputStream());
                cMSTypedData.write((OutputStream)teeOutputStream);
                teeOutputStream.close();
                bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object2).toByteArray());
                dEROctetString = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException iOException) {
                throw new CMSException("exception decoding algorithm parameters.", iOException);
            }
            object2 = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.EMPTY_MAP).toASN1EncodableVector()) : null;
            teeOutputStream = new ContentInfo(CMSObjectIdentifiers.data, (DEREncodable)bERConstructedOctetString);
            authenticatedData = new AuthenticatedData(null, (ASN1Set)new DERSet(aSN1EncodableVector), macCalculator.getAlgorithmIdentifier(), null, (ContentInfo)teeOutputStream, null, (ASN1OctetString)dEROctetString, (ASN1Set)object2);
        }
        object2 = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (DEREncodable)authenticatedData);
        return new CMSAuthenticatedData((ContentInfo)object2, new DigestCalculatorProvider(){

            @Override
            public DigestCalculator get(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }

    public CMSAuthenticatedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        DEROctetString dEROctetString;
        BERConstructedOctetString bERConstructedOctetString;
        ByteArrayOutputStream byteArrayOutputStream;
        AlgorithmIdentifier algorithmIdentifier;
        Object object2;
        SecretKey secretKey;
        Provider provider2 = keyGenerator.getProvider();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            Iterator iterator = CMSEnvelopedHelper.INSTANCE.getMac(string, provider2);
            secretKey = keyGenerator.generateKey();
            object2 = this.generateParameterSpec(string, secretKey, provider2);
            ((Mac)((Object)iterator)).init(secretKey, (AlgorithmParameterSpec)object2);
            algorithmIdentifier = this.getAlgorithmIdentifier(string, (AlgorithmParameterSpec)object2, provider2);
            byteArrayOutputStream = new ByteArrayOutputStream();
            TeeOutputStream teeOutputStream = new TeeOutputStream((OutputStream)byteArrayOutputStream, (OutputStream)new MacOutputStream((Mac)((Object)iterator)));
            cMSProcessable.write((OutputStream)teeOutputStream);
            teeOutputStream.close();
            byteArrayOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
            dEROctetString = new DEROctetString(((Mac)((Object)iterator)).doFinal());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("exception setting up parameters.", invalidParameterSpecException);
        }
        for (Object object2 : this.oldRecipientInfoGenerators) {
            try {
                aSN1EncodableVector.add((DEREncodable)object2.generate(secretKey, this.rand, provider));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        for (Object object2 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add((DEREncodable)object2.generate(new GenericKey(secretKey)));
        }
        object2 = new ContentInfo(CMSObjectIdentifiers.data, (DEREncodable)bERConstructedOctetString);
        byteArrayOutputStream = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (DEREncodable)new AuthenticatedData(null, (ASN1Set)new DERSet(aSN1EncodableVector), algorithmIdentifier, null, (ContentInfo)object2, null, (ASN1OctetString)dEROctetString, null));
        return new CMSAuthenticatedData((ContentInfo)byteArrayOutputStream);
    }

    public CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string, CMSUtils.getProvider(string2));
    }

    public CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, provider);
    }
}

