/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.IntRecipientInfoGenerator;

class KEKIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private SecretKey keyEncryptionKey;
    private KEKIdentifier kekIdentifier;
    private AlgorithmIdentifier keyEncryptionAlgorithm;

    KEKIntRecipientInfoGenerator() {
    }

    void setKeyEncryptionKey(SecretKey secretKey) {
        this.keyEncryptionKey = secretKey;
        this.keyEncryptionAlgorithm = KEKIntRecipientInfoGenerator.determineKeyEncAlg(secretKey);
    }

    void setKEKIdentifier(KEKIdentifier kEKIdentifier) {
        this.kekIdentifier = kEKIdentifier;
    }

    @Override
    public RecipientInfo generate(SecretKey secretKey, SecureRandom secureRandom, Provider provider) throws GeneralSecurityException {
        Cipher cipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(this.keyEncryptionAlgorithm.getObjectId().getId(), provider);
        cipher.init(3, (Key)this.keyEncryptionKey, secureRandom);
        byte[] byArray = cipher.wrap(secretKey);
        DEROctetString dEROctetString = new DEROctetString(byArray);
        return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.keyEncryptionAlgorithm, (ASN1OctetString)dEROctetString));
    }

    private static AlgorithmIdentifier determineKeyEncAlg(SecretKey secretKey) {
        String string = secretKey.getAlgorithm();
        if (string.startsWith("DES")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), (DEREncodable)new DERNull());
        }
        if (string.startsWith("RC2")) {
            return new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), (DEREncodable)new DERInteger(58));
        }
        if (string.startsWith("AES")) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            int n = secretKey.getEncoded().length * 8;
            if (n == 128) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes128_wrap;
            } else if (n == 192) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes192_wrap;
            } else if (n == 256) {
                aSN1ObjectIdentifier = NISTObjectIdentifiers.id_aes256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in AES");
            }
            return new AlgorithmIdentifier((DERObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (string.startsWith("SEED")) {
            return new AlgorithmIdentifier((DERObjectIdentifier)KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        }
        if (string.startsWith("Camellia")) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            int n = secretKey.getEncoded().length * 8;
            if (n == 128) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia128_wrap;
            } else if (n == 192) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia192_wrap;
            } else if (n == 256) {
                aSN1ObjectIdentifier = NTTObjectIdentifiers.id_camellia256_wrap;
            } else {
                throw new IllegalArgumentException("illegal keysize in Camellia");
            }
            return new AlgorithmIdentifier((DERObjectIdentifier)aSN1ObjectIdentifier);
        }
        throw new IllegalArgumentException("unknown algorithm");
    }
}

