/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.text.DecimalFormatUtil;

public abstract class DoubleConversionUtil {
    public static Double toDouble(Object o) {
        return DoubleConversionUtil.toDouble(o, null);
    }

    public static Double toDouble(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        if (o instanceof String) {
            return DoubleConversionUtil.toDouble((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Double(new SimpleDateFormat(pattern).format(o));
            }
            return new Double(((Date)o).getTime());
        }
        return DoubleConversionUtil.toDouble(o.toString());
    }

    private static Double toDouble(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return new Double(DecimalFormatUtil.normalize(s));
    }

    public static double toPrimitiveDouble(Object o) {
        return DoubleConversionUtil.toPrimitiveDouble(o, null);
    }

    public static double toPrimitiveDouble(Object o, String pattern) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return DoubleConversionUtil.toPrimitiveDouble((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Double.parseDouble(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        return DoubleConversionUtil.toPrimitiveDouble(o.toString());
    }

    private static double toPrimitiveDouble(String s) {
        if (StringUtil.isEmpty(s)) {
            return 0.0;
        }
        return Double.parseDouble(DecimalFormatUtil.normalize(s));
    }
}

