/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.text.DecimalFormatUtil;

public abstract class FloatConversionUtil {
    public static Float toFloat(Object o) {
        return FloatConversionUtil.toFloat(o, null);
    }

    public static Float toFloat(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return (Float)o;
        }
        if (o instanceof Number) {
            return new Float(((Number)o).floatValue());
        }
        if (o instanceof String) {
            return FloatConversionUtil.toFloat((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return new Float(new SimpleDateFormat(pattern).format(o));
            }
            return new Float(((Date)o).getTime());
        }
        return FloatConversionUtil.toFloat(o.toString());
    }

    private static Float toFloat(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return new Float(DecimalFormatUtil.normalize(s));
    }

    public static float toPrimitiveFloat(Object o) {
        return FloatConversionUtil.toPrimitiveFloat(o, null);
    }

    public static float toPrimitiveFloat(Object o, String pattern) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof String) {
            return FloatConversionUtil.toPrimitiveFloat((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Float.parseFloat(new SimpleDateFormat(pattern).format(o));
            }
            return ((Date)o).getTime();
        }
        return FloatConversionUtil.toPrimitiveFloat(o.toString());
    }

    private static float toPrimitiveFloat(String s) {
        if (StringUtil.isEmpty(s)) {
            return 0.0f;
        }
        return Float.parseFloat(DecimalFormatUtil.normalize(s));
    }
}

