/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.BitDataBrokenException;
import jp.gr.java_conf.dangan.io.BitInputStream;
import jp.gr.java_conf.dangan.io.NotEnoughBitsException;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;

public class PreLh3Decoder
implements PreLzssDecoder {
    private static final int DictionarySize = 8192;
    private static final int MaxMatch = 256;
    private static final int Threshold = 3;
    private static final int CodeSize = 286;
    private BitInputStream in;
    private int blockSize;
    private int[] codeLen;
    private short[] codeTable;
    private int codeTableBits;
    private short[][] codeTree;
    private int[] offHiLen;
    private short[] offHiTable;
    private int offHiTableBits;
    private short[][] offHiTree;
    private int markBlockSize;
    private int[] markCodeLen;
    private short[] markCodeTable;
    private short[][] markCodeTree;
    private int[] markOffHiLen;
    private short[] markOffHiTable;
    private short[][] markOffHiTree;

    private PreLh3Decoder() {
    }

    public PreLh3Decoder(InputStream inputStream) {
        this(inputStream, 12, 8);
    }

    public PreLh3Decoder(InputStream inputStream, int n, int n2) {
        if (inputStream == null || 0 >= n || 0 >= n2) {
            if (inputStream == null) {
                throw new NullPointerException("in");
            }
            if (n <= 0) {
                throw new IllegalArgumentException("CodeTableBits too small. CodeTableBits must be larger than 1.");
            }
            throw new IllegalArgumentException("OffHiTableBits too small. OffHiTableBits must be larger than 1.");
        }
        this.in = inputStream instanceof BitInputStream ? (BitInputStream)inputStream : new BitInputStream(inputStream);
        this.blockSize = 0;
        this.codeTableBits = n;
        this.offHiTableBits = n2;
    }

    public int readCode() throws IOException {
        int n;
        if (this.blockSize <= 0) {
            this.readBlockHead();
        }
        --this.blockSize;
        try {
            short s = this.codeTable[this.in.peekBits(this.codeTableBits)];
            if (s < 0) {
                n = ~s;
                this.in.skipBits(this.codeLen[n]);
            } else {
                this.in.skipBits(this.codeTableBits);
                while (0 <= (s = this.codeTree[this.in.readBit()][s])) {
                }
                n = ~s;
            }
        }
        catch (NotEnoughBitsException notEnoughBitsException) {
            int n2 = notEnoughBitsException.getAvailableBits();
            int n3 = this.in.peekBits(n2);
            short s = this.codeTable[n3 <<= this.codeTableBits - n2];
            if (s < 0) {
                n = ~s;
                if (this.in.skipBits(this.codeLen[n]) < this.codeLen[n]) {
                    throw new EOFException();
                }
            }
            this.in.skipBits(n2);
            throw new EOFException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
        if (n == 285) {
            n += this.in.readBits(8);
        }
        return n;
    }

    public int readOffset() throws IOException {
        int n;
        try {
            short s = this.offHiTable[this.in.peekBits(this.offHiTableBits)];
            if (s < 0) {
                n = ~s;
                this.in.skipBits(this.offHiLen[n]);
            } else {
                this.in.skipBits(this.offHiTableBits);
                while (0 <= (s = this.offHiTree[this.in.readBit()][s])) {
                }
                n = ~s;
            }
        }
        catch (NotEnoughBitsException notEnoughBitsException) {
            int n2 = notEnoughBitsException.getAvailableBits();
            int n3 = this.in.peekBits(n2);
            short s = this.offHiTable[n3 <<= this.offHiTableBits - n2];
            if (s < 0) {
                n = ~s;
                if (this.offHiLen[n] <= n2) {
                    this.in.skipBits(this.offHiLen[n]);
                }
                this.in.skipBits(n2);
                throw new EOFException();
            }
            this.in.skipBits(n2);
            throw new EOFException();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
        return n << 6 | this.in.readBits(6);
    }

    public void mark(int n) {
        if (this.blockSize < (n = n * 16 / 8)) {
            n += 245;
        }
        this.in.mark(n);
        this.markBlockSize = this.blockSize;
        this.markCodeLen = this.codeLen;
        this.markCodeTable = this.codeTable;
        this.markCodeTree = this.codeTree;
        this.markOffHiLen = this.offHiLen;
        this.markOffHiTable = this.offHiTable;
        this.markOffHiTree = this.offHiTree;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.blockSize = this.markBlockSize;
        this.codeLen = this.markCodeLen;
        this.codeTable = this.markCodeTable;
        this.codeTree = this.markCodeTree;
        this.offHiLen = this.markOffHiLen;
        this.offHiTable = this.markOffHiTable;
        this.offHiTree = this.markOffHiTree;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        int n = this.in.available() * 8 / 16;
        if (this.blockSize < n) {
            n -= 245;
        }
        return Math.max(n, 0);
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.blockSize = 0;
        this.codeLen = null;
        this.codeTable = null;
        this.codeTree = null;
        this.offHiLen = null;
        this.offHiTable = null;
        this.offHiTree = null;
        this.markBlockSize = 0;
        this.markCodeLen = null;
        this.markCodeTable = null;
        this.markCodeTree = null;
        this.markOffHiLen = null;
        this.markOffHiTable = null;
        this.markOffHiTree = null;
    }

    public int getDictionarySize() {
        return 8192;
    }

    public int getMaxMatch() {
        return 256;
    }

    public int getThreshold() {
        return 3;
    }

    private void readBlockHead() throws IOException {
        int n;
        try {
            this.blockSize = this.in.readBits(16);
        }
        catch (BitDataBrokenException bitDataBrokenException) {
            if (bitDataBrokenException.getCause() instanceof EOFException) {
                throw (EOFException)bitDataBrokenException.getCause();
            }
            throw bitDataBrokenException;
        }
        this.codeLen = this.readCodeLen();
        if (1 < this.codeLen.length) {
            short[][] sArray = StaticHuffman.createTableAndTree(this.codeLen, this.codeTableBits);
            this.codeTable = sArray[0];
            this.codeTree = new short[][]{sArray[1], sArray[2]};
        } else {
            int n2 = this.codeLen[0];
            this.codeLen = new int[286];
            this.codeTable = new short[1 << this.codeTableBits];
            for (n = 0; n < this.codeTable.length; ++n) {
                this.codeTable[n] = (short)(~n2);
            }
            this.codeTree = new short[][]{new short[0], new short[0]};
        }
        this.offHiLen = this.readOffHiLen();
        if (1 < this.offHiLen.length) {
            short[][] sArray = StaticHuffman.createTableAndTree(this.offHiLen, this.offHiTableBits);
            this.offHiTable = sArray[0];
            this.offHiTree = new short[][]{sArray[1], sArray[2]};
        } else {
            int n3 = this.offHiLen[0];
            this.offHiLen = new int[128];
            this.offHiTable = new short[1 << this.offHiTableBits];
            for (n = 0; n < this.offHiTable.length; ++n) {
                this.offHiTable[n] = (short)(~n3);
            }
            this.offHiTree = new short[][]{new short[0], new short[0]};
        }
    }

    private int[] readCodeLen() throws IOException {
        int[] nArray = new int[286];
        for (int i = 0; i < nArray.length; ++i) {
            if (this.in.readBoolean()) {
                nArray[i] = this.in.readBits(4) + 1;
            }
            if (i != 2 || nArray[0] != 1 || nArray[1] != 1 || nArray[2] != 1) continue;
            return new int[]{this.in.readBits(9)};
        }
        return nArray;
    }

    private int[] readOffHiLen() throws IOException {
        if (this.in.readBoolean()) {
            int[] nArray = new int[128];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.in.readBits(4);
                if (i != 2 || nArray[0] != 1 || nArray[1] != 1 || nArray[2] != 1) continue;
                return new int[]{this.in.readBits(7)};
            }
            return nArray;
        }
        return PreLh3Decoder.createConstOffHiLen();
    }

    private static int[] createConstOffHiLen() {
        int[] nArray = new int[]{2, 1, 1, 3, 6, 13, 31, 78, 0};
        int[] nArray2 = new int[128];
        int n = 0;
        int n2 = nArray[n++];
        for (int i = 0; i < 128; ++i) {
            while (nArray[n] == i) {
                ++n2;
                ++n;
            }
            nArray2[i] = n2;
        }
        return nArray2;
    }
}

