/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.text.NumberFormat;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class FloatFormatter
implements Formatter {
    public static final FloatFormatter INSTANCE = new FloatFormatter();

    FloatFormatter() {
    }

    public boolean format(JSON.Context context, Object object, Object object2, OutputSource outputSource) throws Exception {
        NumberFormat numberFormat = context.getNumberFormat();
        if (numberFormat != null) {
            StringFormatter.serialize(context, numberFormat.format(object2), outputSource);
        } else {
            double d = ((Number)object2).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                if (context.getMode() != JSON.Mode.SCRIPT) {
                    outputSource.append('\"');
                    outputSource.append(object2.toString());
                    outputSource.append('\"');
                } else if (Double.isNaN(d)) {
                    outputSource.append("Number.NaN");
                } else {
                    outputSource.append("Number.");
                    outputSource.append(d > 0.0 ? "POSITIVE" : "NEGATIVE");
                    outputSource.append("_INFINITY");
                }
            } else {
                outputSource.append(object2.toString());
            }
        }
        return false;
    }
}

