/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.mail.builder.impl;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.mobylet.core.MobyletRuntimeException;
import org.mobylet.mail.MailConstants;
import org.mobylet.mail.builder.HtmlPart;
import org.mobylet.mail.builder.MobyletMailBuilder;
import org.mobylet.mail.message.MessageBody;
import org.mobylet.mail.message.MobyletMessage;
import org.mobylet.mail.util.DataHandlerUtils;
import org.mobylet.mail.util.PartUtils;

public class MobyletHtmlMailBuilder
implements MobyletMailBuilder,
MailConstants {
    @Override
    public MobyletMessage build(MobyletMessage message) {
        return this.buildHtmlMail(message);
    }

    public MobyletMessage buildHtmlMail(MobyletMessage message) {
        MimeMultipart multipart = this.buildHtmlMultipart(message);
        if (message.getBody().getAttaches().size() > 0) {
            try {
                for (MessageBody.Attach attach : message.getBody().getAttaches()) {
                    multipart.addBodyPart((BodyPart)PartUtils.buildAttachPart(message.getCarrier(), attach));
                }
            }
            catch (MessagingException e) {
                throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u69cb\u7bc9\u6642\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
            }
        }
        try {
            message.setContent((Multipart)multipart);
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30e1\u30c3\u30bb\u30fc\u30b8\u69cb\u7bc9\u6642\u306b\u4f8b\u5916\u767a\u751f", (Exception)((Object)e));
        }
        return message;
    }

    public MimeMultipart buildHtmlMultipart(MobyletMessage message) {
        HtmlPart htmlPart = PartUtils.buildHtmlPart(message.getCarrier(), message.getBody().getHtml());
        MimeMultipart multipart = new MimeMultipart();
        try {
            multipart.setSubType("related");
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setDataHandler(DataHandlerUtils.getDataHandler(message.getCarrier(), htmlPart.getSource()));
            bodyPart.addHeader("Content-Transfer-Encoding", "7bit");
            bodyPart.addHeader("Content-Type", "text/html; charset=\"" + message.getNotifyCharset() + "\"");
            multipart.addBodyPart((BodyPart)bodyPart);
            if (htmlPart.getInlineParts() != null && htmlPart.getInlineParts().size() > 0) {
                for (MimeBodyPart inlinePart : htmlPart.getInlineParts()) {
                    multipart.addBodyPart((BodyPart)inlinePart);
                }
            }
            return multipart;
        }
        catch (MessagingException e) {
            throw new MobyletRuntimeException("\u30d1\u30fc\u30c8\u306e\u8a2d\u5b9a\u306b\u5931\u6557", (Exception)((Object)e));
        }
    }
}

