/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.solr.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.codelibs.solr.lib.exception.SolrLibException;
import org.codelibs.solr.lib.exception.SolrLibGroupNotAvailableException;
import org.codelibs.solr.lib.exception.SolrLibQueryException;
import org.codelibs.solr.lib.exception.SolrLibServerNotAvailableException;
import org.codelibs.solr.lib.exception.SolrLibServiceException;
import org.codelibs.solr.lib.policy.QueryType;
import org.codelibs.solr.lib.policy.StatusPolicy;
import org.seasar.util.log.Logger;

public class SolrGroup {
    private static final Logger logger = Logger.getLogger(SolrGroup.class);
    protected static final int MAX_LOAD_COUNT = 0x3FFFFFFF;
    protected Map<String, SolrServer> solrServerMap = new LinkedHashMap<String, SolrServer>();
    protected String groupName;
    protected ConcurrentHashMap<String, AtomicInteger> accessCountMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, AtomicInteger> errorCountMap = new ConcurrentHashMap();
    protected StatusPolicy statusPolicy;

    public void addServer(String name, SolrServer solrServer) {
        this.solrServerMap.put(name, solrServer);
    }

    public String[] getServerNames() {
        return this.solrServerMap.keySet().toArray(new String[this.solrServerMap.size()]);
    }

    public Collection<UpdateResponse> add(final Collection<SolrInputDocument> docs) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.add(docs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> add(final SolrInputDocument doc) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.add(doc);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> addBean(final Object obj) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.addBean(obj);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> addBean(final Collection<?> beans) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.addBeans(beans);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> commit() {
        this.checkStatus(QueryType.COMMIT);
        return this.updateQueryCallback(QueryType.COMMIT, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.commit();
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> commit(final boolean waitFlush, final boolean waitSearcher) {
        this.checkStatus(QueryType.COMMIT);
        return this.updateQueryCallback(QueryType.COMMIT, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.commit(waitFlush, waitSearcher);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> deleteByQuery(final String query) {
        this.checkStatus(QueryType.DELETE);
        return this.updateQueryCallback(QueryType.DELETE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.deleteByQuery(query);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> deleteById(final String id) {
        this.checkStatus(QueryType.DELETE);
        return this.updateQueryCallback(QueryType.DELETE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.deleteById(id);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> optimize() {
        this.checkStatus(QueryType.OPTIMIZE);
        return this.updateQueryCallback(QueryType.OPTIMIZE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.optimize();
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> optimize(final boolean waitFlush, final boolean waitSearcher) {
        this.checkStatus(QueryType.OPTIMIZE);
        return this.updateQueryCallback(QueryType.OPTIMIZE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.optimize(waitFlush, waitSearcher);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> optimize(final boolean waitFlush, final boolean waitSearcher, final int maxSegments) {
        this.checkStatus(QueryType.OPTIMIZE);
        return this.updateQueryCallback(QueryType.OPTIMIZE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.optimize(waitFlush, waitSearcher, maxSegments);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<SolrPingResponse> ping() {
        this.checkStatus(QueryType.PING);
        return this.updateQueryCallback(QueryType.PING, new UpdateProcessCallback<SolrPingResponse>(){

            @Override
            public SolrPingResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.ping();
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public QueryResponse query(SolrParams params) {
        return this.query(params, SolrRequest.METHOD.GET);
    }

    public QueryResponse query(SolrParams params, SolrRequest.METHOD method) {
        this.checkStatus(QueryType.QUERY);
        SolrLibServiceException fsqe = null;
        int maxRetryCount = this.statusPolicy.getMaxRetryCount(QueryType.QUERY);
        for (int i = 0; i < maxRetryCount; ++i) {
            try {
                return this.queryInternal(params, method);
            }
            catch (SolrLibQueryException e) {
                throw e;
            }
            catch (Exception e) {
                if (fsqe == null) {
                    fsqe = new SolrLibServiceException("ESL0011", new Object[]{params.toString()});
                }
                fsqe.addException(e);
                this.statusPolicy.sleep(QueryType.QUERY);
                continue;
            }
        }
        throw fsqe;
    }

    private QueryResponse queryInternal(SolrParams params, SolrRequest.METHOD method) {
        String solrServerName = null;
        try {
            SolrServer solrServer = null;
            AtomicInteger minValue = null;
            for (Map.Entry<String, SolrServer> entry : this.solrServerMap.entrySet()) {
                AtomicInteger count = this.accessCountMap.get(entry.getKey());
                if (count == null) {
                    count = new AtomicInteger(1);
                    AtomicInteger accessCount = this.accessCountMap.putIfAbsent(entry.getKey(), count);
                    if (accessCount != null) {
                        accessCount.getAndIncrement();
                        count = accessCount;
                    }
                }
                if (minValue != null && count.get() >= minValue.get() || !this.statusPolicy.isActive(QueryType.QUERY, entry.getKey())) continue;
                minValue = count;
                solrServerName = entry.getKey();
                solrServer = entry.getValue();
            }
            if (solrServer == null) {
                throw new SolrLibException("ESL0002", new Object[]{this.groupName});
            }
            if (minValue.getAndIncrement() > 0x3FFFFFFF) {
                this.accessCountMap.clear();
            }
            if (!this.statusPolicy.isActive(QueryType.QUERY, solrServerName)) {
                throw new SolrLibServerNotAvailableException(this.groupName, solrServerName);
            }
            QueryResponse queryResponse = solrServer.query(params, method);
            this.errorCountMap.remove(solrServerName);
            return queryResponse;
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                switch (((SolrException)e).code()) {
                    case 500: {
                        throw new SolrLibQueryException("ESL0013", new Object[]{params}, e);
                    }
                }
            }
            throw this.getQueryException(QueryType.QUERY, params, solrServerName, e);
        }
    }

    public NamedList<Object> request(SolrRequest request) {
        this.checkStatus(QueryType.REQUEST);
        SolrLibServiceException fsqe = null;
        int maxRetryCount = this.statusPolicy.getMaxRetryCount(QueryType.REQUEST);
        for (int i = 0; i < maxRetryCount; ++i) {
            try {
                return this.requestInternal(request);
            }
            catch (SolrLibQueryException e) {
                throw e;
            }
            catch (Exception e) {
                if (fsqe == null) {
                    fsqe = new SolrLibServiceException("ESL0011", new Object[]{request.toString()});
                }
                fsqe.addException(e);
                this.statusPolicy.sleep(QueryType.REQUEST);
                continue;
            }
        }
        throw fsqe;
    }

    private NamedList<Object> requestInternal(SolrRequest request) {
        String solrServerName = null;
        try {
            SolrServer solrServer = null;
            AtomicInteger minValue = null;
            for (Map.Entry<String, SolrServer> entry : this.solrServerMap.entrySet()) {
                AtomicInteger count = this.accessCountMap.get(entry.getKey());
                if (count == null) {
                    count = new AtomicInteger(1);
                    AtomicInteger accessCount = this.accessCountMap.putIfAbsent(entry.getKey(), count);
                    if (accessCount != null) {
                        accessCount.getAndIncrement();
                        count = accessCount;
                    }
                }
                if (minValue != null && count.get() >= minValue.get() || !this.statusPolicy.isActive(QueryType.REQUEST, entry.getKey())) continue;
                minValue = count;
                solrServerName = entry.getKey();
                solrServer = entry.getValue();
            }
            if (solrServer == null) {
                throw new SolrLibException("ESL0002", new Object[]{this.groupName});
            }
            if (minValue.getAndIncrement() > 0x3FFFFFFF) {
                this.accessCountMap.clear();
            }
            if (!this.statusPolicy.isActive(QueryType.REQUEST, solrServerName)) {
                throw new SolrLibServerNotAvailableException(this.groupName, solrServerName);
            }
            NamedList response = solrServer.request(request);
            this.errorCountMap.remove(solrServerName);
            return response;
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                switch (((SolrException)e).code()) {
                    case 500: {
                        throw new SolrLibQueryException("ESL0013", new Object[]{request}, e);
                    }
                }
            }
            throw this.getQueryException(QueryType.REQUEST, request, solrServerName, e);
        }
    }

    protected SolrLibException getQueryException(QueryType queryType, Object selectQuery, String solrServerName, Exception e) {
        if (solrServerName != null) {
            AtomicInteger count;
            AtomicInteger errorCount = this.errorCountMap.get(solrServerName);
            if (errorCount == null && (count = this.errorCountMap.putIfAbsent(solrServerName, errorCount = new AtomicInteger(0))) != null) {
                errorCount = count;
            }
            int maxErrorCount = this.statusPolicy.getMaxErrorCount(queryType);
            if (errorCount.get() > maxErrorCount) {
                this.statusPolicy.deactivate(queryType, solrServerName);
                this.errorCountMap.remove(solrServerName);
                return new SolrLibException("ESL0003", new Object[]{solrServerName, this.groupName, errorCount, maxErrorCount}, e);
            }
            errorCount.getAndIncrement();
            return new SolrLibException("ESL0004", new Object[]{solrServerName, this.groupName, errorCount, maxErrorCount}, e);
        }
        return new SolrLibException("ESL0005", new Object[]{selectQuery.toString()}, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Collection<T> updateQueryCallback(QueryType queryType, UpdateProcessCallback<T> upc) {
        ArrayList resultList = new ArrayList();
        StatusPolicy statusPolicy = this.statusPolicy;
        synchronized (statusPolicy) {
            for (Map.Entry<String, SolrServer> entry : this.solrServerMap.entrySet()) {
                String serverName = entry.getKey();
                if (!this.statusPolicy.isActive(queryType, serverName)) continue;
                this.executeUpdateQuery(queryType, upc, resultList, entry, serverName, 0);
            }
        }
        return resultList;
    }

    protected <T> void executeUpdateQuery(QueryType queryType, UpdateProcessCallback<T> upc, List<T> resultList, Map.Entry<String, SolrServer> entry, String serverName, int retryCount) {
        try {
            resultList.add(upc.callback(entry.getValue()));
        }
        catch (Exception e) {
            logger.log(Logger.format((String)"WSL0003", (Object[])new Object[]{serverName, upc, retryCount}), (Throwable)e);
            if (retryCount > this.statusPolicy.getMaxRetryCount(queryType)) {
                this.statusPolicy.deactivate(queryType, serverName);
            }
            this.statusPolicy.sleep(queryType);
            this.executeUpdateQuery(queryType, upc, resultList, entry, serverName, retryCount + 1);
        }
    }

    public boolean isActive(QueryType queryType) {
        return this.statusPolicy.isActive(queryType, this.solrServerMap.keySet());
    }

    protected void checkStatus(QueryType queryType) {
        if (!this.statusPolicy.isActive(queryType, this.solrServerMap.keySet())) {
            throw new SolrLibGroupNotAvailableException(this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus() {
        StatusPolicy statusPolicy = this.statusPolicy;
        synchronized (statusPolicy) {
            for (Map.Entry<String, SolrServer> entry : this.solrServerMap.entrySet()) {
                String serverName = entry.getKey();
                if (this.statusPolicy.isActive(QueryType.PING, serverName)) continue;
                try {
                    SolrPingResponse pingResponse = entry.getValue().ping();
                    if (pingResponse.getStatus() == 0) {
                        this.statusPolicy.activate(QueryType.PING, serverName);
                        continue;
                    }
                    logger.log("WSL0002", new Object[]{serverName, pingResponse.getStatus()});
                    this.statusPolicy.deactivate(QueryType.PING, serverName);
                }
                catch (Exception e) {
                    logger.log(Logger.format((String)"WSL0001", (Object[])new Object[]{serverName}), (Throwable)e);
                    this.statusPolicy.deactivate(QueryType.PING, serverName);
                }
            }
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public StatusPolicy getStatusPolicy() {
        return this.statusPolicy;
    }

    public void setStatusPolicy(StatusPolicy statusPolicy) {
        this.statusPolicy = statusPolicy;
    }

    protected static interface UpdateProcessCallback<V> {
        public V callback(SolrServer var1);
    }
}

