/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.List;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkOperation;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class ZkCmdExecutor {
    private long retryDelay = 1300L;
    private int retryCount;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    public ZkCmdExecutor(int timeoutms) {
        double timeouts = (double)timeoutms / 1000.0;
        this.retryCount = Math.round(0.5f * ((float)Math.sqrt(8.0 * timeouts + 1.0) - 1.0f));
    }

    public List<ACL> getAcl() {
        return this.acl;
    }

    public void setAcl(List<ACL> acl) {
        this.acl = acl;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public <T> T retryOperation(ZkOperation operation) throws KeeperException, InterruptedException {
        KeeperException.ConnectionLossException exception = null;
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return (T)operation.execute();
            }
            catch (KeeperException.ConnectionLossException e) {
                if (exception == null) {
                    exception = e;
                }
                if (Thread.currentThread().isInterrupted()) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedException();
                }
                if (Thread.currentThread() instanceof ClosableThread && ((ClosableThread)((Object)Thread.currentThread())).isClosed()) {
                    throw exception;
                }
                this.retryDelay(i);
                continue;
            }
        }
        throw exception;
    }

    public void ensureExists(String path, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        this.ensureExists(path, null, CreateMode.PERSISTENT, zkClient);
    }

    public void ensureExists(String path, byte[] data, CreateMode createMode, SolrZkClient zkClient) throws KeeperException, InterruptedException {
        if (zkClient.exists(path, true).booleanValue()) {
            return;
        }
        try {
            zkClient.makePath(path, data, true);
        }
        catch (KeeperException.NodeExistsException e) {
            // empty catch block
        }
    }

    protected void retryDelay(int attemptCount) throws InterruptedException {
        if (attemptCount > 0) {
            Thread.sleep((long)attemptCount * this.retryDelay);
        }
    }
}

