/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public class Rank
extends Var2or3ArgFunction {
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        AreaEval aeRange;
        double result;
        try {
            ValueEval ve = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
            result = OperandResolver.coerceValueToDouble(ve);
            if (Double.isNaN(result) || Double.isInfinite(result)) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            aeRange = Rank.convertRangeArg(arg1);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return Rank.eval(srcRowIndex, srcColumnIndex, result, aeRange, true);
    }

    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        AreaEval aeRange;
        double result;
        boolean order;
        block5: {
            order = false;
            try {
                ValueEval ve = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
                result = OperandResolver.coerceValueToDouble(ve);
                if (Double.isNaN(result) || Double.isInfinite(result)) {
                    throw new EvaluationException(ErrorEval.NUM_ERROR);
                }
                aeRange = Rank.convertRangeArg(arg1);
                ve = OperandResolver.getSingleValue(arg2, srcRowIndex, srcColumnIndex);
                int order_value = OperandResolver.coerceValueToInt(ve);
                if (order_value == 0) {
                    order = true;
                    break block5;
                }
                if (order_value == 1) {
                    order = false;
                    break block5;
                }
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
        }
        return Rank.eval(srcRowIndex, srcColumnIndex, result, aeRange, order);
    }

    private static ValueEval eval(int srcRowIndex, int srcColumnIndex, double arg0, AreaEval aeRange, boolean descending_order) {
        int rank = 1;
        int height = aeRange.getHeight();
        int width = aeRange.getWidth();
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                Double value = Rank.getValue(aeRange, r, c);
                if (value == null || !(descending_order && value > arg0) && (descending_order || !(value < arg0))) continue;
                ++rank;
            }
        }
        return new NumberEval(rank);
    }

    private static Double getValue(AreaEval aeRange, int relRowIndex, int relColIndex) {
        ValueEval addend = aeRange.getRelativeValue(relRowIndex, relColIndex);
        if (addend instanceof NumberEval) {
            return ((NumberEval)addend).getNumberValue();
        }
        return null;
    }

    private static AreaEval convertRangeArg(ValueEval eval) throws EvaluationException {
        if (eval instanceof AreaEval) {
            return (AreaEval)eval;
        }
        if (eval instanceof RefEval) {
            return ((RefEval)eval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

