/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import java.lang.annotation.Annotation;

public final class RuntimeTestGroup {
    private final Annotation annotation;
    private final TestGroup testGroup;
    private final String name;
    private final String sysProperty;
    private boolean enabled;

    RuntimeTestGroup(Annotation ann) {
        this.annotation = ann;
        this.name = RuntimeTestGroup.getGroupName(ann.annotationType());
        this.sysProperty = RuntimeTestGroup.getGroupSysProperty(ann.annotationType());
        this.testGroup = ann.annotationType().getAnnotation(TestGroup.class);
        try {
            this.enabled = RandomizedTest.systemPropertyAsBoolean(this.getSysPropertyName(), this.testGroup.enabled());
        }
        catch (IllegalArgumentException e) {
            this.enabled = false;
        }
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public String getSysPropertyName() {
        return this.sysProperty;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static String getGroupName(Class<? extends Annotation> annotationClass) {
        TestGroup testGroup = annotationClass.getAnnotation(TestGroup.class);
        if (testGroup == null) {
            throw new IllegalArgumentException("Annotation must have a @TestGroup annotation: " + annotationClass);
        }
        String tmp = RandomizedRunner.emptyToNull(testGroup.name());
        return tmp == null ? annotationClass.getSimpleName().toLowerCase() : tmp;
    }

    public static String getGroupSysProperty(Class<? extends Annotation> annotationClass) {
        TestGroup testGroup = annotationClass.getAnnotation(TestGroup.class);
        String tmp = RandomizedRunner.emptyToNull(testGroup.sysProperty());
        return tmp != null ? tmp : SysGlobals.prefixProperty(RuntimeTestGroup.getGroupName(annotationClass));
    }
}

