/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.LookaheadTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util._TestUtil;

public final class MockGraphTokenFilter
extends LookaheadTokenFilter<LookaheadTokenFilter.Position> {
    private static boolean DEBUG = false;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final long seed;
    private Random random;

    public MockGraphTokenFilter(Random random, TokenStream input) {
        super(input);
        this.seed = random.nextLong();
    }

    @Override
    protected LookaheadTokenFilter.Position newPosition() {
        return new LookaheadTokenFilter.Position();
    }

    @Override
    protected void afterPosition() throws IOException {
        if (DEBUG) {
            System.out.println("MockGraphTF.afterPos");
        }
        if (this.random.nextInt(7) == 5) {
            int posLength = _TestUtil.nextInt(this.random, 1, 5);
            if (DEBUG) {
                System.out.println("  do insert! posLen=" + posLength);
            }
            LookaheadTokenFilter.Position posEndData = (LookaheadTokenFilter.Position)this.positions.get(this.outputPos + posLength);
            while (!this.end && posEndData.endOffset == -1 && this.inputPos <= this.outputPos + posLength && this.peekToken()) {
            }
            if (posEndData.endOffset != -1) {
                this.insertToken();
                this.clearAttributes();
                this.posLenAtt.setPositionLength(posLength);
                this.termAtt.append(_TestUtil.randomUnicodeString(this.random));
                this.posIncAtt.setPositionIncrement(0);
                this.offsetAtt.setOffset(((LookaheadTokenFilter.Position)this.positions.get((int)this.outputPos)).startOffset, posEndData.endOffset);
                if (DEBUG) {
                    System.out.println("  inject: outputPos=" + this.outputPos + " startOffset=" + this.offsetAtt.startOffset() + " endOffset=" + this.offsetAtt.endOffset() + " posLength=" + this.posLenAtt.getPositionLength());
                }
            }
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.random = new Random(this.seed);
    }

    public boolean incrementToken() throws IOException {
        if (DEBUG) {
            System.out.println("MockGraphTF.incr inputPos=" + this.inputPos + " outputPos=" + this.outputPos);
        }
        return this.nextToken();
    }
}

