/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Random;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterPerThreadPool;

class RandomDocumentsWriterPerThreadPool
extends DocumentsWriterPerThreadPool {
    private final DocumentsWriterPerThreadPool.ThreadState[] states;
    private final Random random;
    private final int maxRetry;

    public RandomDocumentsWriterPerThreadPool(int maxNumPerThreads, Random random) {
        super(maxNumPerThreads);
        assert (this.getMaxThreadStates() >= 1);
        this.states = new DocumentsWriterPerThreadPool.ThreadState[maxNumPerThreads];
        this.random = new Random(random.nextLong());
        this.maxRetry = 1 + random.nextInt(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentsWriterPerThreadPool.ThreadState getAndLock(Thread requestingThread, DocumentsWriter documentsWriter) {
        DocumentsWriterPerThreadPool.ThreadState threadState = null;
        if (this.getActiveThreadState() == 0) {
            RandomDocumentsWriterPerThreadPool randomDocumentsWriterPerThreadPool = this;
            synchronized (randomDocumentsWriterPerThreadPool) {
                if (this.getActiveThreadState() == 0) {
                    threadState = this.states[0] = this.newThreadState();
                    return threadState;
                }
            }
        }
        assert (this.getActiveThreadState() > 0);
        for (int i = 0; i < this.maxRetry; ++i) {
            int ord = this.random.nextInt(this.getActiveThreadState());
            RandomDocumentsWriterPerThreadPool randomDocumentsWriterPerThreadPool = this;
            synchronized (randomDocumentsWriterPerThreadPool) {
                threadState = this.states[ord];
                assert (threadState != null);
            }
            if (threadState.tryLock()) {
                return threadState;
            }
            if (this.random.nextInt(20) == 0) break;
        }
        RandomDocumentsWriterPerThreadPool randomDocumentsWriterPerThreadPool = this;
        synchronized (randomDocumentsWriterPerThreadPool) {
            DocumentsWriterPerThreadPool.ThreadState newThreadState = this.newThreadState();
            if (newThreadState != null) {
                DocumentsWriterPerThreadPool.ThreadState threadState2 = newThreadState;
                this.states[this.getActiveThreadState() - 1] = threadState2;
                threadState = threadState2;
                assert (threadState.isHeldByCurrentThread());
                return threadState;
            }
        }
        assert (threadState != null);
        threadState.lock();
        return threadState;
    }
}

