/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.GzipHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class JettySolrRunner {
    Server server;
    FilterHolder dispatchFilter;
    FilterHolder debugFilter;
    String context;
    private String solrConfigFilename;
    private String schemaFilename;
    private boolean waitOnSolr = false;
    private int lastPort = -1;
    private String shards;
    private String dataDir;
    private volatile boolean startedBefore = false;
    private String solrHome;
    private boolean stopAtShutdown;

    public JettySolrRunner(String solrHome, String context, int port) {
        this.init(solrHome, context, port, true);
    }

    public JettySolrRunner(String solrHome, String context, int port, String solrConfigFilename, String schemaFileName) {
        this.init(solrHome, context, port, true);
        this.solrConfigFilename = solrConfigFilename;
        this.schemaFilename = schemaFileName;
    }

    public JettySolrRunner(String solrHome, String context, int port, String solrConfigFilename, String schemaFileName, boolean stopAtShutdown) {
        this.init(solrHome, context, port, stopAtShutdown);
        this.solrConfigFilename = solrConfigFilename;
        this.schemaFilename = schemaFileName;
    }

    private void init(String solrHome, String context, int port, boolean stopAtShutdown) {
        this.context = context;
        this.server = new Server(port);
        this.solrHome = solrHome;
        this.stopAtShutdown = stopAtShutdown;
        this.server.setStopAtShutdown(stopAtShutdown);
        if (!stopAtShutdown) {
            this.server.setGracefulShutdown(0);
        }
        System.setProperty("solr.solr.home", solrHome);
        if (System.getProperty("jetty.testMode") != null) {
            QueuedThreadPool threadPool;
            SelectChannelConnector connector;
            String connectorName = System.getProperty("tests.jettyConnector", "SelectChannel");
            if ("SelectChannel".equals(connectorName)) {
                SelectChannelConnector c = new SelectChannelConnector();
                c.setReuseAddress(true);
                c.setLowResourcesMaxIdleTime(1500);
                connector = c;
                threadPool = (QueuedThreadPool)c.getThreadPool();
            } else if ("Socket".equals(connectorName)) {
                SocketConnector c = new SocketConnector();
                c.setReuseAddress(true);
                connector = c;
                threadPool = (QueuedThreadPool)c.getThreadPool();
            } else {
                throw new IllegalArgumentException("Illegal value for system property 'tests.jettyConnector': " + connectorName);
            }
            connector.setPort(port);
            connector.setHost("127.0.0.1");
            if (threadPool != null) {
                threadPool.setMaxThreads(10000);
                threadPool.setMaxIdleTimeMs(5000);
                threadPool.setMaxStopTimeMs(30000);
            }
            this.server.setConnectors(new Connector[]{connector});
            this.server.setSessionIdManager((SessionIdManager)new HashSessionIdManager(new Random()));
        } else {
            for (Connector connector : this.server.getConnectors()) {
                QueuedThreadPool threadPool = null;
                if (connector instanceof SocketConnector) {
                    threadPool = (QueuedThreadPool)((SocketConnector)connector).getThreadPool();
                }
                if (connector instanceof SelectChannelConnector) {
                    threadPool = (QueuedThreadPool)((SelectChannelConnector)connector).getThreadPool();
                }
                if (threadPool == null) continue;
                threadPool.setMaxThreads(10000);
                threadPool.setMaxIdleTimeMs(5000);
                if (stopAtShutdown) continue;
                threadPool.setMaxStopTimeMs(100);
            }
        }
        final ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.server, context, 1);
        root.setHandler((Handler)new GzipHandler());
        this.server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStopping(LifeCycle arg0) {
                System.clearProperty("hostPort");
            }

            public void lifeCycleStopped(LifeCycle arg0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void lifeCycleStarting(LifeCycle arg0) {
                JettySolrRunner jettySolrRunner = JettySolrRunner.this;
                synchronized (jettySolrRunner) {
                    JettySolrRunner.this.waitOnSolr = true;
                    JettySolrRunner.this.notify();
                }
            }

            public void lifeCycleStarted(LifeCycle arg0) {
                JettySolrRunner.this.lastPort = JettySolrRunner.this.getFirstConnectorPort();
                System.setProperty("hostPort", Integer.toString(JettySolrRunner.this.lastPort));
                if (JettySolrRunner.this.solrConfigFilename != null) {
                    System.setProperty("solrconfig", JettySolrRunner.this.solrConfigFilename);
                }
                if (JettySolrRunner.this.schemaFilename != null) {
                    System.setProperty("schema", JettySolrRunner.this.schemaFilename);
                }
                JettySolrRunner.this.debugFilter = root.addFilter(DebugFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
                JettySolrRunner.this.dispatchFilter = root.addFilter(SolrDispatchFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
                if (JettySolrRunner.this.solrConfigFilename != null) {
                    System.clearProperty("solrconfig");
                }
                if (JettySolrRunner.this.schemaFilename != null) {
                    System.clearProperty("schema");
                }
                System.clearProperty("solr.solr.home");
            }

            public void lifeCycleFailure(LifeCycle arg0, Throwable arg1) {
                System.clearProperty("hostPort");
            }
        });
        root.addServlet(Servlet404.class, "/*");
    }

    public FilterHolder getDispatchFilter() {
        return this.dispatchFilter;
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public boolean isStopped() {
        return this.server.isStopped();
    }

    public void start() throws Exception {
        this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean waitForSolr) throws Exception {
        if (this.startedBefore) {
            this.waitOnSolr = false;
            this.init(this.solrHome, this.context, this.lastPort, this.stopAtShutdown);
        } else {
            this.startedBefore = true;
        }
        if (this.dataDir != null) {
            System.setProperty("solr.data.dir", this.dataDir);
        }
        if (this.shards != null) {
            System.setProperty("shard", this.shards);
        }
        if (!this.server.isRunning()) {
            this.server.start();
        }
        JettySolrRunner jettySolrRunner = this;
        synchronized (jettySolrRunner) {
            int cnt = 0;
            while (!this.waitOnSolr) {
                this.wait(100L);
                if (cnt++ != 5) continue;
                throw new RuntimeException("Jetty/Solr unresponsive");
            }
        }
        System.clearProperty("shard");
        System.clearProperty("solr.data.dir");
    }

    public void stop() throws Exception {
        Filter filter = this.dispatchFilter.getFilter();
        this.server.stop();
        if (this.server.getState().equals("FAILED")) {
            filter.destroy();
        }
        this.server.join();
    }

    private int getFirstConnectorPort() {
        Connector[] conns = this.server.getConnectors();
        if (0 == conns.length) {
            throw new RuntimeException("Jetty Server has no Connectors");
        }
        return conns[0].getLocalPort();
    }

    public int getLocalPort() {
        if (this.lastPort == -1) {
            throw new IllegalStateException("You cannot get the port until this instance has started");
        }
        return this.lastPort;
    }

    public DebugFilter getDebugFilter() {
        return (DebugFilter)this.debugFilter.getFilter();
    }

    public static void main(String[] args) {
        try {
            JettySolrRunner jetty = new JettySolrRunner(".", "/solr", 8983);
            jetty.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setShards(String shardList) {
        this.shards = shardList;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public static class Servlet404
    extends HttpServlet {
        public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
            res.sendError(404, "Can not find: " + req.getRequestURI());
        }
    }

    public static class DebugFilter
    implements Filter {
        public int requestsToKeep = 10;
        private AtomicLong nRequests = new AtomicLong();
        private LinkedList<HttpServletRequest> requests = new LinkedList();

        public long getTotalRequests() {
            return this.nRequests.get();
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            this.nRequests.incrementAndGet();
            filterChain.doFilter(servletRequest, servletResponse);
        }

        public void destroy() {
        }
    }
}

