/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrXMLSerializer {
    protected static Logger log = LoggerFactory.getLogger(SolrXMLSerializer.class);
    private static final String INDENT = "  ";

    void persist(Writer w, SolrXMLDef solrXMLDef) throws IOException {
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        w.write("<solr");
        Map<String, String> rootSolrAttribs = solrXMLDef.solrAttribs;
        Set<String> solrAttribKeys = rootSolrAttribs.keySet();
        for (String key : solrAttribKeys) {
            String value = rootSolrAttribs.get(key);
            this.writeAttribute(w, key, value);
        }
        w.write(">\n");
        Properties containerProperties = solrXMLDef.containerProperties;
        if (containerProperties != null && !containerProperties.isEmpty()) {
            this.writeProperties(w, containerProperties, INDENT);
        }
        w.write("  <cores");
        Map<String, String> coresAttribs = solrXMLDef.coresAttribs;
        Set<String> coreAttribKeys = coresAttribs.keySet();
        for (String key : coreAttribKeys) {
            String value = coresAttribs.get(key);
            this.writeAttribute(w, key, value);
        }
        w.write(">\n");
        for (SolrCoreXMLDef coreDef : solrXMLDef.coresDefs) {
            this.persist(w, coreDef);
        }
        w.write("  </cores>\n");
        w.write("</solr>\n");
    }

    private void persist(Writer w, SolrCoreXMLDef coreDef) throws IOException {
        w.write("    <core");
        Set<String> keys = coreDef.coreAttribs.keySet();
        for (String key : keys) {
            this.writeAttribute(w, key, coreDef.coreAttribs.get(key));
        }
        Properties properties = coreDef.coreProperties;
        if (properties == null || properties.isEmpty()) {
            w.write("/>\n");
        } else {
            w.write(">\n");
            this.writeProperties(w, properties, "      ");
            w.write("    </core>\n");
        }
    }

    private void writeProperties(Writer w, Properties props, String indent) throws IOException {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            w.write(indent + "<property");
            this.writeAttribute(w, "name", entry.getKey());
            this.writeAttribute(w, "value", entry.getValue());
            w.write("/>\n");
        }
    }

    private void writeAttribute(Writer w, String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        w.write(" ");
        w.write(name);
        w.write("=\"");
        XML.escapeAttributeValue((String)value.toString(), (Writer)w);
        w.write("\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistFile(File file, SolrXMLDef solrXMLDef) {
        log.info("Persisting cores config to " + file);
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("solr", ".xml", file.getParentFile());
            FileOutputStream out = new FileOutputStream(tmpFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            try {
                this.persist((Writer)writer, solrXMLDef);
            }
            finally {
                ((Writer)writer).close();
                out.close();
            }
            if (tmpFile != null) {
                if (tmpFile.renameTo(file)) {
                    tmpFile = null;
                } else {
                    SolrXMLSerializer.fileCopy(tmpFile, file);
                }
            }
        }
        catch (FileNotFoundException xnf) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)xnf);
        }
        catch (IOException xio) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)xio);
        }
        finally {
            if (tmpFile != null && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fileCopy(File src, File dest) throws IOException {
        IOException xforward = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            fcin = fis.getChannel();
            fcout = fos.getChannel();
            int MB32 = 0x2000000;
            long size = ((FileChannel)fcin).size();
            for (long position = 0L; position < size; position += ((FileChannel)fcin).transferTo(position, 0x2000000L, (WritableByteChannel)((Object)fcout))) {
            }
        }
        catch (IOException xio) {
            xforward = xio;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException xio) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException xio) {}
            }
            if (fcin != null && fcin.isOpen()) {
                try {
                    fcin.close();
                    fcin = null;
                }
                catch (IOException xio) {}
            }
            if (fcout != null && fcout.isOpen()) {
                try {
                    fcout.close();
                    fcout = null;
                }
                catch (IOException xio) {}
            }
        }
        if (xforward != null) {
            throw xforward;
        }
    }

    public static class SolrCoreXMLDef {
        Properties coreProperties;
        Map<String, String> coreAttribs;
    }

    public static class SolrXMLDef {
        Properties containerProperties;
        Map<String, String> solrAttribs;
        Map<String, String> coresAttribs;
        List<SolrCoreXMLDef> coresDefs;
    }
}

