/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.DirectoryFactory;

public class StandardDirectoryFactory
extends CachingDirectoryFactory {
    @Override
    protected Directory create(String path, DirectoryFactory.DirContext dirContext) throws IOException {
        return FSDirectory.open((File)new File(path));
    }

    @Override
    public String normalize(String path) throws IOException {
        return new File(path).getCanonicalPath();
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public void remove(Directory dir) throws IOException {
        CachingDirectoryFactory.CacheValue val = (CachingDirectoryFactory.CacheValue)this.byDirectoryCache.get(dir);
        if (val == null) {
            throw new IllegalArgumentException("Unknown directory " + dir);
        }
        File dirFile = new File(val.path);
        FileUtils.deleteDirectory((File)dirFile);
    }

    @Override
    public void remove(String path) throws IOException {
        String fullPath = new File(path).getAbsolutePath();
        File dirFile = new File(fullPath);
        FileUtils.deleteDirectory((File)dirFile);
    }

    @Override
    public void move(Directory fromDir, Directory toDir, String fileName, IOContext ioContext) throws IOException {
        File dir2;
        File indexFileInIndex;
        File dir1;
        File indexFileInTmpDir;
        boolean success;
        if (fromDir instanceof FSDirectory && toDir instanceof FSDirectory && (success = (indexFileInTmpDir = new File(dir1 = ((FSDirectory)fromDir).getDirectory(), fileName)).renameTo(indexFileInIndex = new File(dir2 = ((FSDirectory)toDir).getDirectory(), fileName)))) {
            return;
        }
        super.move(fromDir, toDir, fileName, ioContext);
    }
}

