/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.schema.SchemaField;

public class FieldFacetStats {
    public final String name;
    final FieldCache.DocTermsIndex si;
    final SchemaField facet_sf;
    final SchemaField field_sf;
    final int startTermIndex;
    final int endTermIndex;
    final int nTerms;
    final int numStatsTerms;
    public final Map<String, StatsValues> facetStatsValues;
    final List<HashMap<String, Integer>> facetStatsTerms;
    private final BytesRef tempBR = new BytesRef();

    public FieldFacetStats(String name, FieldCache.DocTermsIndex si, SchemaField field_sf, SchemaField facet_sf, int numStatsTerms) {
        this.name = name;
        this.si = si;
        this.field_sf = field_sf;
        this.facet_sf = facet_sf;
        this.numStatsTerms = numStatsTerms;
        this.startTermIndex = 1;
        this.endTermIndex = si.numOrd();
        this.nTerms = this.endTermIndex - this.startTermIndex;
        this.facetStatsValues = new HashMap<String, StatsValues>();
        this.facetStatsTerms = new ArrayList<HashMap<String, Integer>>();
        if (numStatsTerms == 0) {
            return;
        }
        for (int i = 0; i < numStatsTerms; ++i) {
            this.facetStatsTerms.add(new HashMap());
        }
    }

    BytesRef getTermText(int docID, BytesRef ret) {
        int ord = this.si.getOrd(docID);
        if (ord == 0) {
            return null;
        }
        return this.si.lookup(ord, ret);
    }

    public boolean facet(int docID, BytesRef v) {
        int term = this.si.getOrd(docID);
        int arrIdx = term - this.startTermIndex;
        if (arrIdx >= 0 && arrIdx < this.nTerms) {
            BytesRef br = this.si.lookup(term, this.tempBR);
            String key = br == null ? null : this.facet_sf.getType().indexedToReadable(br.utf8ToString());
            StatsValues stats = this.facetStatsValues.get(key);
            if (stats == null) {
                stats = StatsValuesFactory.createStatsValues(this.field_sf);
                this.facetStatsValues.put(key, stats);
            }
            if (v == null || v.length <= 0) {
                stats.missing();
                return false;
            }
            stats.accumulate(v);
            return true;
        }
        return false;
    }

    public boolean facetTermNum(int docID, int statsTermNum) {
        int term = this.si.getOrd(docID);
        int arrIdx = term - this.startTermIndex;
        if (arrIdx >= 0 && arrIdx < this.nTerms) {
            BytesRef br = this.si.lookup(term, this.tempBR);
            String key = br == null ? null : br.utf8ToString();
            HashMap<String, Integer> statsTermCounts = this.facetStatsTerms.get(statsTermNum);
            Integer statsTermCount = statsTermCounts.get(key);
            if (statsTermCount == null) {
                statsTermCounts.put(key, 1);
            } else {
                statsTermCounts.put(key, statsTermCount + 1);
            }
            return true;
        }
        return false;
    }

    public boolean accumulateTermNum(int statsTermNum, BytesRef value) {
        if (value == null) {
            return false;
        }
        for (Map.Entry<String, Integer> stringIntegerEntry : this.facetStatsTerms.get(statsTermNum).entrySet()) {
            Integer count;
            Map.Entry<String, Integer> pairs = stringIntegerEntry;
            String key = pairs.getKey();
            StatsValues facetStats = this.facetStatsValues.get(key);
            if (facetStats == null) {
                facetStats = StatsValuesFactory.createStatsValues(this.field_sf);
                this.facetStatsValues.put(key, facetStats);
            }
            if ((count = pairs.getValue()) == null) continue;
            facetStats.accumulate(value, count);
        }
        return true;
    }
}

