/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.logging.CircularList;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LoggerInfo;

public abstract class LogWatcher<E> {
    protected CircularList<E> history;
    protected long last = -1L;

    public abstract String getName();

    public abstract List<String> getAllLevels();

    public abstract void setLogLevel(String var1, String var2);

    public abstract Collection<LoggerInfo> getAllLoggers();

    public abstract void setThreshold(String var1);

    public abstract String getThreshold();

    public void add(E event, long timstamp) {
        this.history.add(event);
        this.last = timstamp;
    }

    public long getLastEvent() {
        return this.last;
    }

    public int getHistorySize() {
        return this.history == null ? -1 : this.history.getBufferSize();
    }

    public SolrDocumentList getHistory(long since, AtomicBoolean found) {
        if (this.history == null) {
            return null;
        }
        SolrDocumentList docs = new SolrDocumentList();
        for (E e : this.history) {
            long ts = this.getTimestamp(e);
            if (ts == since && found != null) {
                found.set(true);
            }
            if (ts <= since) continue;
            docs.add((Object)this.toSolrDocument(e));
        }
        docs.setNumFound((long)docs.size());
        return docs;
    }

    public abstract long getTimestamp(E var1);

    public abstract SolrDocument toSolrDocument(E var1);

    public abstract void registerListener(ListenerConfig var1, CoreContainer var2);

    public void reset() {
        this.history.clear();
        this.last = -1L;
    }
}

