/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldProperties;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.Sorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldType
extends FieldProperties {
    public static final Logger log = LoggerFactory.getLogger(FieldType.class);
    public static final String POLY_FIELD_SEPARATOR = "___";
    protected String typeName;
    protected Map<String, String> args;
    protected int trueProperties;
    protected int falseProperties;
    int properties;
    protected Analyzer analyzer;
    protected Analyzer queryAnalyzer;
    protected Similarity similarity;
    protected String postingsFormat;

    public FieldType() {
        this.queryAnalyzer = this.analyzer = new DefaultAnalyzer(256);
    }

    public boolean isTokenized() {
        return (this.properties & 2) != 0;
    }

    public boolean isMultiValued() {
        return (this.properties & 0x200) != 0;
    }

    protected boolean hasProperty(int p) {
        return (this.properties & p) != 0;
    }

    public boolean isPolyField() {
        return false;
    }

    public boolean multiValuedFieldCache() {
        return this.isTokenized();
    }

    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    protected String getArg(String n, Map<String, String> args) {
        String s = args.remove(n);
        if (s == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing parameter '" + n + "' for FieldType=" + this.typeName + args);
        }
        return s;
    }

    void setArgs(IndexSchema schema, Map<String, String> args) {
        String postingsFormat;
        this.properties = 5;
        float schemaVersion = schema.getVersion();
        if (schemaVersion < 1.1f) {
            this.properties |= 0x200;
        }
        if (schemaVersion > 1.1f) {
            this.properties |= 0x20;
        }
        if ((double)schemaVersion < 1.3) {
            args.remove("compressThreshold");
        }
        this.args = args;
        HashMap<String, String> initArgs = new HashMap<String, String>(args);
        this.trueProperties = FieldProperties.parseProperties(initArgs, true);
        this.falseProperties = FieldProperties.parseProperties(initArgs, false);
        this.properties &= ~this.falseProperties;
        this.properties |= this.trueProperties;
        for (String prop : FieldProperties.propertyNames) {
            initArgs.remove(prop);
        }
        this.init(schema, initArgs);
        String positionInc = (String)initArgs.get("positionIncrementGap");
        if (positionInc != null) {
            Analyzer analyzer = this.getAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            analyzer = this.getQueryAnalyzer();
            if (!(analyzer instanceof SolrAnalyzer)) {
                throw new RuntimeException("Can't set positionIncrementGap on custom analyzer " + analyzer.getClass());
            }
            ((SolrAnalyzer)analyzer).setPositionIncrementGap(Integer.parseInt(positionInc));
            initArgs.remove("positionIncrementGap");
        }
        if ((postingsFormat = (String)initArgs.get("postingsFormat")) != null) {
            this.postingsFormat = postingsFormat;
            initArgs.remove("postingsFormat");
        }
        if (initArgs.size() > 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid arguments:" + initArgs);
        }
    }

    protected void restrictProps(int props) {
        if ((this.properties & props) != 0) {
            throw new RuntimeException("schema fieldtype " + this.typeName + "(" + this.getClass().getName() + ")" + " invalid properties:" + FieldType.propertiesToString(this.properties & props));
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return this.typeName + "{class=" + this.getClass().getName() + (this.analyzer != null ? ",analyzer=" + this.analyzer.getClass().getName() : "") + ",args=" + this.args + "}";
    }

    public IndexableField createField(SchemaField field, Object value, float boost) {
        String val;
        if (!field.indexed() && !field.stored()) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        try {
            val = this.toInternal(value.toString());
        }
        catch (RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while creating field '" + field + "' from value '" + value + "'", (Throwable)e);
        }
        if (val == null) {
            return null;
        }
        org.apache.lucene.document.FieldType newType = new org.apache.lucene.document.FieldType();
        newType.setIndexed(field.indexed());
        newType.setTokenized(field.isTokenized());
        newType.setStored(field.stored());
        newType.setOmitNorms(field.omitNorms());
        newType.setIndexOptions(this.getIndexOptions(field, val));
        newType.setStoreTermVectors(field.storeTermVector());
        newType.setStoreTermVectorOffsets(field.storeTermOffsets());
        newType.setStoreTermVectorPositions(field.storeTermPositions());
        return this.createField(field.getName(), val, newType, boost);
    }

    protected IndexableField createField(String name, String val, org.apache.lucene.document.FieldType type, float boost) {
        Field f = new Field(name, val, type);
        f.setBoost(boost);
        return f;
    }

    public IndexableField[] createFields(SchemaField field, Object value, float boost) {
        IndexableField[] indexableFieldArray;
        IndexableField f = this.createField(field, value, boost);
        if (f == null) {
            indexableFieldArray = new IndexableField[]{};
        } else {
            IndexableField[] indexableFieldArray2 = new IndexableField[1];
            indexableFieldArray = indexableFieldArray2;
            indexableFieldArray2[0] = f;
        }
        return indexableFieldArray;
    }

    protected FieldInfo.IndexOptions getIndexOptions(SchemaField field, String internalVal) {
        FieldInfo.IndexOptions options = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        if (field.omitTermFreqAndPositions()) {
            options = FieldInfo.IndexOptions.DOCS_ONLY;
        } else if (field.omitPositions()) {
            options = FieldInfo.IndexOptions.DOCS_AND_FREQS;
        } else if (field.storeOffsetsWithPositions()) {
            options = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS;
        }
        return options;
    }

    public String toInternal(String val) {
        return val;
    }

    public String toExternal(IndexableField f) {
        return f.stringValue();
    }

    public Object toObject(IndexableField f) {
        return this.toExternal(f);
    }

    public Object toObject(SchemaField sf, BytesRef term) {
        CharsRef ref = new CharsRef(term.length);
        this.indexedToReadable(term, ref);
        IndexableField f = this.createField(sf, ref.toString(), 1.0f);
        return this.toObject(f);
    }

    public String indexedToReadable(String indexedForm) {
        return indexedForm;
    }

    public CharsRef indexedToReadable(BytesRef input, CharsRef output) {
        UnicodeUtil.UTF8toUTF16((BytesRef)input, (CharsRef)output);
        return output;
    }

    public String storedToReadable(IndexableField f) {
        return this.toExternal(f);
    }

    public String storedToIndexed(IndexableField f) {
        return f.stringValue();
    }

    public String readableToIndexed(String val) {
        return this.toInternal(val);
    }

    public void readableToIndexed(CharSequence val, BytesRef result) {
        String internal = this.readableToIndexed(((Object)val).toString());
        UnicodeUtil.UTF16toUTF8((CharSequence)internal, (int)0, (int)internal.length(), (BytesRef)result);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
    }

    public void setQueryAnalyzer(Analyzer analyzer) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "FieldType: " + this.getClass().getSimpleName() + " (" + this.typeName + ") does not support specifying an analyzer");
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public String getPostingsFormat() {
        return this.postingsFormat;
    }

    public abstract void write(TextResponseWriter var1, String var2, IndexableField var3) throws IOException;

    public abstract SortField getSortField(SchemaField var1, boolean var2);

    protected SortField getStringSort(SchemaField field, boolean reverse) {
        field.checkSortability();
        return Sorting.getStringSortField(field.name, reverse, field.sortMissingLast(), field.sortMissingFirst());
    }

    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new StrFieldSource(field.name);
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        return TermRangeQuery.newStringRange((String)field.getName(), (String)(part1 == null ? null : this.toInternal(part1)), (String)(part2 == null ? null : this.toInternal(part2)), (boolean)minInclusive, (boolean)maxInclusive);
    }

    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        BytesRef br = new BytesRef();
        this.readableToIndexed(externalVal, br);
        return new TermQuery(new Term(field.getName(), br));
    }

    public void checkSchemaField(SchemaField field) throws SolrException {
    }

    protected final class DefaultAnalyzer
    extends SolrAnalyzer {
        final int maxChars;

        DefaultAnalyzer(int maxChars) {
            this.maxChars = maxChars;
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            Tokenizer ts = new Tokenizer(reader){
                final char[] cbuf;
                final CharTermAttribute termAtt;
                final OffsetAttribute offsetAtt;
                {
                    this.cbuf = new char[DefaultAnalyzer.this.maxChars];
                    this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                    this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
                }

                public boolean incrementToken() throws IOException {
                    this.clearAttributes();
                    int n = this.input.read(this.cbuf, 0, DefaultAnalyzer.this.maxChars);
                    if (n <= 0) {
                        return false;
                    }
                    String s = FieldType.this.toInternal(new String(this.cbuf, 0, n));
                    this.termAtt.setEmpty().append(s);
                    this.offsetAtt.setOffset(this.correctOffset(0), this.correctOffset(n));
                    return true;
                }
            };
            return new Analyzer.TokenStreamComponents(ts);
        }
    }
}

